/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.uas.security.xuudb;

import de.fzJuelich.unicore.xuudb.GetAttributesRequestDocument;
import de.fzJuelich.unicore.xuudb.GetAttributesRequestType;
import de.fzJuelich.unicore.xuudb.GetAttributesResponseDocument;
import de.fzJuelich.unicore.xuudb.GetAttributesResponseType;
import de.fzJuelich.unicore.xuudb.SimplifiedAttributeType;
import de.fzj.unicore.wsrflite.Kernel;
import de.fzj.unicore.wsrflite.security.IDynamicAttributeSource;
import de.fzj.unicore.xuudb.interfaces.IDynamicAttributesPublic;
import eu.unicore.security.Client;
import eu.unicore.security.SubjectAttributesHolder;
import eu.unicore.security.XACMLAttribute;
import eu.unicore.security.xfireutil.client.XFireClientFactory;
import eu.unicore.uas.security.xuudb.XUUDBAuthoriserBase;
import eu.unicore.uas.security.xuudb.XUUDBBase;
import eu.unicore.util.Log;
import eu.unicore.util.configuration.ConfigurationException;
import eu.unicore.util.httpclient.ClientProperties;
import eu.unicore.util.httpclient.IClientConfiguration;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class XUUDBDynamicAttributeSource
extends XUUDBAuthoriserBase
implements IDynamicAttributeSource {
    private static final Logger logger = Log.getLogger((String)"unicore.security", XUUDBDynamicAttributeSource.class);
    private IDynamicAttributesPublic xuudb;

    public void start(Kernel kernel) throws Exception {
        this.kernel = kernel;
        Kernel.addMBean((Object)new XUUDBBase(this), (String)(this.getServiceName() + " attribute source - " + this.name + " @" + kernel.hashCode()));
        this.xuudb = this.makeDAPEndpoint();
        this.isEnabled = true;
    }

    private synchronized IDynamicAttributesPublic makeDAPEndpoint() {
        if (this.xuudb != null) {
            return this.xuudb;
        }
        try {
            ClientProperties sec = this.kernel.getClientConfiguration().clone();
            return (IDynamicAttributesPublic)new XFireClientFactory((IClientConfiguration)sec).createPlainWSProxy(IDynamicAttributesPublic.class, this.getXUUDBUrl() + "XUUDBDynamicAttributesQuery");
        }
        catch (Exception e) {
            Log.logException((String)("Can't make " + this.getServiceName() + " connection."), (Throwable)e, (Logger)logger);
            return null;
        }
    }

    private String getCacheKey(Client cl) {
        String role;
        StringBuilder cInfo = new StringBuilder();
        if (this.isNotEmpty(cl.getDistinguishedName())) {
            cInfo.append("Name: ");
            cInfo.append(cl.getDistinguishedName());
        }
        if (cl.getXlogin() != null) {
            String xlogin = cl.getXlogin().getUserName();
            String group = cl.getXlogin().getGroup();
            if (this.isNotEmpty(xlogin)) {
                cInfo.append("|Xlogin: ");
                cInfo.append(xlogin);
            }
            if (this.isNotEmpty(group)) {
                cInfo.append("|Group: ");
                cInfo.append(group);
            }
        }
        if (cl.getRole() != null && this.isNotEmpty(role = cl.getRole().getName())) {
            cInfo.append("|Role: ");
            cInfo.append(role);
        }
        if (cl.getQueue() != null && cl.getQueue().getValidQueues().length > 0) {
            cInfo.append("|Queues: ");
            cInfo.append(cl.getQueue());
        }
        if (cl.getVos().length > 0) {
            cInfo.append("|VOs: ");
            cInfo.append(Arrays.toString(cl.getVos()));
        }
        if (this.isNotEmpty(cl.getVo())) {
            cInfo.append("|Selected VO: ").append(cl.getVo());
        }
        for (XACMLAttribute a : cl.getSubjectAttributes().getXacmlAttributes()) {
            cInfo.append("|" + a.getName() + "=" + a.getValue());
        }
        return cInfo.toString();
    }

    public SubjectAttributesHolder getAttributes(Client client, SubjectAttributesHolder otherAuthoriserInfo) throws IOException {
        SubjectAttributesHolder map;
        long begin = System.currentTimeMillis();
        ++this.total_auth;
        SubjectAttributesHolder subjectAttributesHolder = map = this.cacheCredentials != false ? this.cache.read(this.getCacheKey(client)) : null;
        if (map == null) {
            map = this.getDAPAttributes(client, otherAuthoriserInfo);
            if (map != null && this.cacheCredentials.booleanValue()) {
                this.cache.put(this.getCacheKey(client), map);
            }
        } else {
            ++this.cache_hits;
        }
        this.publishTime(System.currentTimeMillis() - begin);
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SubjectAttributesHolder getDAPAttributes(Client client, SubjectAttributesHolder otherAuthoriserInfo) throws IOException {
        GetAttributesResponseDocument resp;
        try {
            XACMLAttribute a2;
            String role;
            GetAttributesRequestType req = GetAttributesRequestType.Factory.newInstance();
            if (this.isNotEmpty(client.getDistinguishedName())) {
                req.setUserDN(client.getDistinguishedName());
            }
            if (client.getRole() != null && this.isNotEmpty(role = client.getRole().getName())) {
                req.setRole(role);
            }
            if (this.isNotEmpty(client.getVo())) {
                req.setVo(client.getVo());
            }
            if (client.getXlogin() != null) {
                String xlogin = client.getXlogin().getUserName();
                String group = client.getXlogin().getGroup();
                if (this.isNotEmpty(xlogin)) {
                    req.setXlogin(xlogin);
                }
                if (this.isNotEmpty(group)) {
                    req.setGid(group);
                }
            }
            ArrayList<SimplifiedAttributeType> al = new ArrayList<SimplifiedAttributeType>();
            for (XACMLAttribute a2 : client.getSubjectAttributes().getXacmlAttributes()) {
                SimplifiedAttributeType ex = SimplifiedAttributeType.Factory.newInstance();
                ex.setName(a2.getName());
                ex.addNewValue().setStringValue(a2.getValue());
                al.add(ex);
            }
            if (al.size() > 0) {
                SimplifiedAttributeType[] ar = new SimplifiedAttributeType[al.size()];
                al.toArray(ar);
                req.setExtraAttributesArray(ar);
            }
            GetAttributesRequestDocument outXml = GetAttributesRequestDocument.Factory.newInstance();
            outXml.setGetAttributesRequest(req);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(this.getServiceName() + " request: " + outXml.toString()));
            }
            a2 = this.xuudb;
            synchronized (a2) {
                resp = this.xuudb.getAttributes(outXml);
            }
        }
        catch (Exception e) {
            IOException ioe = new IOException("Error contacting " + this.getServiceName() + ": " + e.getMessage());
            ioe.initCause(e);
            throw ioe;
        }
        if (logger.isDebugEnabled()) {
            GetAttributesResponseType data = resp.getGetAttributesResponse();
            String reply = "[xlogin=" + data.getXlogin() + ", gid=" + data.getGid() + ", SupplementaryGids=";
            Boolean sgt = false;
            for (String sg : data.getSupplementaryGidsArray()) {
                reply = reply + sg + ":";
                sgt = true;
            }
            if (sgt.booleanValue()) {
                reply = reply.substring(0, reply.length() - 1);
            }
            reply = reply + "]";
            logger.debug((Object)(this.getServiceName() + " reply: " + reply));
        }
        SubjectAttributesHolder map = this.makeAuthInfo(resp.getGetAttributesResponse());
        return map;
    }

    private SubjectAttributesHolder makeAuthInfo(GetAttributesResponseType data) {
        Boolean isEmpty = true;
        String gid = data.getGid();
        String xlogin = data.getXlogin();
        String[] supGids = data.getSupplementaryGidsArray();
        HashMap<String, String[]> map = new HashMap<String, String[]>();
        HashMap<String, String[]> mapDef = new HashMap<String, String[]>();
        if (this.isNotEmpty(xlogin)) {
            isEmpty = false;
            String[] xlogins = new String[]{xlogin};
            map.put("xlogin", xlogins);
            mapDef.put("xlogin", xlogins);
        }
        if (this.isNotEmpty(gid)) {
            isEmpty = false;
            String[] gids = new String[]{gid};
            map.put("group", gids);
            mapDef.put("group", gids);
        }
        if (supGids != null && supGids.length > 0) {
            isEmpty = false;
            map.put("supplementaryGroups", supGids);
            mapDef.put("supplementaryGroups", supGids);
        }
        if (isEmpty.booleanValue()) {
            return null;
        }
        return new SubjectAttributesHolder(mapDef, map);
    }

    @Override
    public String getServiceName() {
        return "XUUDB DAP";
    }

    public void setDAPEndpoint(IDynamicAttributesPublic dap) {
        this.xuudb = dap;
    }

    @Override
    public void configure(String name) throws ConfigurationException {
        super.configure(name);
    }

    @Override
    public String getName() {
        return super.getName();
    }

    @Override
    public String getStatusDescription() {
        return super.getStatusDescription();
    }
}

