/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.uas.security.xuudb;

import de.fzJuelich.unicore.xuudb.CheckCertificateDocument;
import de.fzJuelich.unicore.xuudb.CheckCertificateResponseDocument;
import de.fzJuelich.unicore.xuudb.CheckDNDataType;
import de.fzJuelich.unicore.xuudb.CheckDNDocument;
import de.fzJuelich.unicore.xuudb.CheckDNResponseDocument;
import de.fzJuelich.unicore.xuudb.CheckDataType;
import de.fzJuelich.unicore.xuudb.LoginDataType;
import de.fzj.unicore.wsrflite.Kernel;
import de.fzj.unicore.wsrflite.security.IAttributeSource;
import de.fzj.unicore.wsrflite.security.VODescription;
import de.fzj.unicore.xuudb.X509Utils;
import de.fzj.unicore.xuudb.interfaces.IPublic;
import eu.unicore.security.SecurityTokens;
import eu.unicore.security.SubjectAttributesHolder;
import eu.unicore.security.xfireutil.client.XFireClientFactory;
import eu.unicore.uas.security.xuudb.XUUDB;
import eu.unicore.uas.security.xuudb.XUUDBAuthoriserBase;
import eu.unicore.util.Log;
import eu.unicore.util.httpclient.ClientProperties;
import eu.unicore.util.httpclient.IClientConfiguration;
import java.io.IOException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class XUUDBAuthoriser
extends XUUDBAuthoriserBase
implements IAttributeSource {
    private static final Logger logger = Log.getLogger((String)"unicore.security", XUUDBAuthoriser.class);
    private IPublic xuudb;
    private int auth_by_cert = 0;
    private int auth_by_dn = 0;

    @Override
    public void configure(String name) {
        super.configure(name);
    }

    public void start(Kernel kernel) throws Exception {
        this.kernel = kernel;
        Kernel.addMBean((Object)new XUUDB(this), (String)(this.getServiceName() + " attribute source - " + this.name + " @" + kernel.hashCode()));
        this.xuudb = this.makeEndpoint();
        this.isEnabled = true;
    }

    public void setEndpoint(IPublic xuudb) {
        this.xuudb = xuudb;
    }

    public SubjectAttributesHolder getAttributes(SecurityTokens tokens, SubjectAttributesHolder otherAuthoriserInfo) throws IOException {
        SubjectAttributesHolder map;
        long begin = System.currentTimeMillis();
        ++this.total_auth;
        X509Certificate cert = tokens.getEffectiveUserCertificate();
        if (cert != null) {
            SubjectAttributesHolder subjectAttributesHolder = map = this.cacheCredentials != false ? this.cache.read(cert) : null;
            if (map == null) {
                map = this.checkUserCert(tokens);
                if (this.cacheCredentials.booleanValue()) {
                    this.cache.put(cert, map);
                }
            } else {
                ++this.cache_hits;
            }
        } else {
            SubjectAttributesHolder subjectAttributesHolder = map = this.cacheCredentials != false ? this.cache.read(tokens.getEffectiveUserName()) : null;
            if (map == null) {
                map = this.checkDN(tokens);
                if (this.cacheCredentials.booleanValue()) {
                    this.cache.put(tokens.getEffectiveUserName(), map);
                }
            } else {
                ++this.cache_hits;
            }
        }
        this.publishTime(System.currentTimeMillis() - begin);
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SubjectAttributesHolder checkUserCert(SecurityTokens tokens) throws IOException {
        ++this.auth_by_cert;
        CheckCertificateDocument in = CheckCertificateDocument.Factory.newInstance();
        CheckDataType check = in.addNewCheckCertificate();
        check.setGcID(this.gcID);
        X509Certificate cert = tokens.getEffectiveUserCertificate();
        if (cert == null) {
            return this.checkDN(tokens);
        }
        this.addAccessorName(cert.getSubjectX500Principal().getName());
        CheckCertificateResponseDocument res = null;
        try {
            check.setCertInPEM(X509Utils.getPEMStringFromX509((Certificate)cert));
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("XUUDB request: " + in.toString()));
            }
            IPublic iPublic = this.xuudb;
            synchronized (iPublic) {
                res = this.xuudb.checkCertificate(in);
            }
        }
        catch (Exception e) {
            IOException ioe = new IOException("Error contacting " + this.getServiceName() + ": " + e.getMessage());
            ioe.initCause(e);
            throw ioe;
        }
        if (logger.isDebugEnabled()) {
            LoginDataType login = res.getCheckCertificateResponse();
            String reply = "[xlogin=" + login.getXlogin() + ", role=" + login.getRole() + ", projects=" + login.getProjects() + "]";
            logger.debug((Object)("XUUDB reply: " + reply));
        }
        SubjectAttributesHolder map = this.makeAuthInfo(res.getCheckCertificateResponse());
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SubjectAttributesHolder checkDN(SecurityTokens tokens) throws IOException {
        ++this.auth_by_dn;
        CheckDNDocument in = CheckDNDocument.Factory.newInstance();
        CheckDNDataType check = in.addNewCheckDN();
        check.setGcID(this.gcID);
        String dn = tokens.getEffectiveUserName().getName();
        this.addAccessorName(dn);
        check.setDistinguishedName(dn);
        CheckDNResponseDocument res = null;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(this.getServiceName() + " request: " + in.toString()));
        }
        IPublic iPublic = this.xuudb;
        synchronized (iPublic) {
            try {
                res = this.xuudb.checkDN(in);
            }
            catch (Exception e) {
                Log.logException((String)("Error contacting " + this.getServiceName() + "."), (Throwable)e, (Logger)logger);
                IOException ioe = new IOException("Error contacting " + this.getServiceName() + ": " + e.getMessage());
                ioe.initCause(e);
                throw ioe;
            }
        }
        if (logger.isDebugEnabled()) {
            LoginDataType login = res.getCheckDNResponse();
            String reply = "[xlogin=" + login.getXlogin() + ", role=" + login.getRole() + ", projects=" + login.getProjects() + "]";
            logger.debug((Object)(this.getServiceName() + " reply: " + reply));
        }
        SubjectAttributesHolder map = this.makeAuthInfo(res.getCheckDNResponse());
        return map;
    }

    public SubjectAttributesHolder makeAuthInfo(LoginDataType login) {
        String role = login.getRole();
        String xlogin = login.getXlogin();
        String groups = login.getProjects();
        HashMap<String, String[]> map = new HashMap<String, String[]>();
        HashMap<String, String[]> mapDef = new HashMap<String, String[]>();
        if (this.isNotEmpty(xlogin)) {
            String[] xlogins = this.decode(xlogin);
            map.put("xlogin", xlogins);
            if (xlogins.length > 0) {
                mapDef.put("xlogin", new String[]{xlogins[0]});
            }
        }
        if (this.isNotEmpty(role)) {
            String[] roles = this.decode(role);
            map.put("role", roles);
            mapDef.put("role", new String[]{roles[0]});
        }
        if (this.isNotEmpty(groups)) {
            String[] gids = this.decode(groups);
            map.put("group", gids);
            mapDef.put("group", new String[]{gids[0]});
        }
        return new SubjectAttributesHolder(mapDef, map);
    }

    protected String[] decode(String in) {
        ArrayList<String> res = new ArrayList<String>();
        for (String s : in.split(":")) {
            String v = s.trim();
            if (v.length() == 0) continue;
            res.add(v);
        }
        return res.toArray(new String[res.size()]);
    }

    protected synchronized IPublic makeEndpoint() {
        if (this.xuudb != null) {
            return this.xuudb;
        }
        try {
            ClientProperties sec = this.kernel.getClientConfiguration().clone();
            return (IPublic)new XFireClientFactory((IClientConfiguration)sec).createPlainWSProxy(IPublic.class, this.getXUUDBUrl() + "XUUDBQuery");
        }
        catch (Exception e) {
            Log.logException((String)("Can't make " + this.getServiceName() + " connection."), (Throwable)e, (Logger)logger);
            return null;
        }
    }

    public int getAuthorisationsByCert() {
        return this.auth_by_cert;
    }

    public int getAuthorisationsByDN() {
        return this.auth_by_dn;
    }

    @Override
    public void clearStatistics() {
        super.clearStatistics();
        this.auth_by_cert = 0;
        this.auth_by_dn = 0;
    }

    public VODescription[] getAcceptedVOs() {
        return null;
    }
}

