/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.uas.security.xuudb;

import eu.unicore.security.SubjectAttributesHolder;
import eu.unicore.util.Log;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import org.apache.log4j.Logger;

public class CredentialCache {
    private static final Logger log = Log.getLogger((String)"unicore.security", CredentialCache.class);
    private CacheManager cacheManager;
    private Cache cache;
    private String defaultConfig;

    public CredentialCache() {
        this(10);
    }

    public CredentialCache(int timeToLive) {
        this.defaultConfig = "<ehcache>\n<defaultCache maxElementsInMemory=\"100\"\neternal=\"false\"\ntimeToIdleSeconds=\"" + timeToLive + "\"\n" + "timeToLiveSeconds=\"" + timeToLive + "\"\n" + "overflowToDisk=\"false\"\n" + "diskPersistent=\"false\"\n" + "diskExpiryThreadIntervalSeconds=\"120\"/>\n" + "</ehcache>";
        if (this.cacheManager == null) {
            this.initCacheManager();
        }
        if (!this.cacheManager.cacheExists(CredentialCache.class.getName())) {
            this.cacheManager.addCache(CredentialCache.class.getName());
        }
        this.cache = this.cacheManager.getCache(CredentialCache.class.getName());
    }

    private synchronized void initCacheManager() {
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(this.defaultConfig.getBytes());
            this.cacheManager = new CacheManager((InputStream)bis);
        }
        catch (CacheException e) {
            log.fatal((Object)"Error creating cache manager.", (Throwable)e);
        }
    }

    public SubjectAttributesHolder read(Object key) {
        try {
            Element e = this.cache.get(key);
            if (e != null) {
                return (SubjectAttributesHolder)e.getValue();
            }
        }
        catch (Exception e) {
            log.warn((Object)"", (Throwable)e);
        }
        return null;
    }

    public void put(Object key, SubjectAttributesHolder authzInfo) {
        try {
            this.cache.put(new Element(key, (Object)authzInfo));
        }
        catch (Exception e) {
            log.warn((Object)"", (Throwable)e);
        }
    }

    public void removeAll() {
        try {
            this.cache.removeAll();
        }
        catch (Exception e) {
            log.warn((Object)"Could not clear cache.", (Throwable)e);
        }
    }

    public Cache getCache() {
        return this.cache;
    }
}

