/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.uas.security.vo.conf;

import eu.emi.security.authn.x509.X509CertChainValidator;
import eu.unicore.security.canl.LoggingStoreUpdateListener;
import eu.unicore.security.canl.TruststoreProperties;
import eu.unicore.uas.security.vo.conf.IPullConfiguration;
import eu.unicore.uas.security.vo.conf.IPushConfiguration;
import eu.unicore.util.Log;
import eu.unicore.util.configuration.ConfigurationException;
import eu.unicore.util.configuration.DocumentationReferenceMeta;
import eu.unicore.util.configuration.DocumentationReferencePrefix;
import eu.unicore.util.configuration.FilePropertiesHelper;
import eu.unicore.util.configuration.PropertyMD;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;

public class PropertiesBasedConfiguration
extends FilePropertiesHelper
implements IPullConfiguration,
IPushConfiguration {
    private static final Logger log = Log.getLogger((String)"unicore.security.vocommon", PropertiesBasedConfiguration.class);
    @DocumentationReferencePrefix
    public static final String PREFIX = "vo.";
    public static final String DEF_CONFIG_FILE_PATH = "conf/vo.config";
    public static final String ENV_CONFIG_FILE = "pl.edu.icm.uasvo.configFile";
    public static final String CFG_INCARNATION_ATTR_PFX = "unicoreAttribute.";
    public static final String CFG_VO_SERVICE_SCOPE = "group";
    public static final String CFG_VO_SERVICE_URI = "voServerURI";
    public static final String CFG_DISABLE_PULL_WHEN_PUSHED = "pull.disableIfAttributesWerePushed";
    public static final String CFG_PULL_ENABLE = "pull.enable";
    public static final String CFG_PULL_GENERIC_ENABLE = "pull.enableGenericAttributes";
    public static final String CFG_SERVER_URI = "localServerURI";
    public static final String CFG_VO_SERVICE_HOST = "pull.voHost";
    public static final String CFG_VO_SERVICE_PORT = "pull.voPort";
    public static final String CFG_VO_SERVICE_PATH = "pull.voPath";
    public static final String CFG_VO_PULL_CACHE = "pull.cacheTtl";
    public static final String CFG_VO_VERIFY_SIGNATURES = "pull.verifySignatures";
    public static final String CFG_PULL_TD = "pull.enableTrustDelegation";
    public static final String CFG_PUSH_ENABLE = "push.enable";
    @DocumentationReferenceMeta
    public static final Map<String, PropertyMD> DEFAULTS = new HashMap<String, PropertyMD>();
    private TruststoreProperties trustProperties;

    public PropertiesBasedConfiguration() throws FileNotFoundException, IOException {
        this(null);
    }

    public PropertiesBasedConfiguration(String configFile) throws FileNotFoundException, IOException {
        super(PREFIX, PropertiesBasedConfiguration.getConfigFile(configFile), DEFAULTS, log);
        boolean enabled;
        this.trustProperties = new TruststoreProperties(this.properties, Collections.singleton(new LoggingStoreUpdateListener()), "vo.truststore.");
        boolean bl = enabled = this.isPullEnabled() || this.isPushEnabled();
        if (enabled && this.getScope() == null) {
            throw new ConfigurationException("For the VO subsystem, the group must be defined.");
        }
        if (enabled && this.getVOServiceURI() == null) {
            throw new ConfigurationException("For the VO subsystem, the voServerURI must be defined.");
        }
    }

    private static String getConfigFile(String preferred) {
        String cfgFile = preferred;
        if (cfgFile == null) {
            cfgFile = System.getProperty(ENV_CONFIG_FILE);
        }
        if (cfgFile == null) {
            cfgFile = DEF_CONFIG_FILE_PATH;
        }
        return cfgFile;
    }

    @Override
    public int getChacheTtl() {
        return this.getIntValue(CFG_VO_PULL_CACHE);
    }

    @Override
    public String getVOServiceHost() {
        return this.getValue(CFG_VO_SERVICE_HOST);
    }

    @Override
    public String getVOServicePath() {
        return this.getValue(CFG_VO_SERVICE_PATH);
    }

    @Override
    public int getVOServicePort() {
        return this.getIntValue(CFG_VO_SERVICE_PORT);
    }

    @Override
    public String getVOServiceURI() {
        return this.getValue(CFG_VO_SERVICE_URI);
    }

    @Override
    public boolean isPullEnabled() {
        return this.getBooleanValue(CFG_PULL_ENABLE);
    }

    @Override
    public boolean isPulledSignatureVerficationEnabled() {
        return this.getBooleanValue(CFG_VO_VERIFY_SIGNATURES);
    }

    @Override
    public boolean isPulledGenericAttributesEnabled() {
        return this.getBooleanValue(CFG_PULL_GENERIC_ENABLE);
    }

    @Override
    public String getScope() {
        return this.getValue(CFG_VO_SERVICE_SCOPE);
    }

    @Override
    public String getServerURI() {
        return this.getValue(CFG_SERVER_URI);
    }

    @Override
    public boolean isPushEnabled() {
        return this.getBooleanValue(CFG_PUSH_ENABLE);
    }

    @Override
    public boolean enableTD() {
        return this.getBooleanValue(CFG_PULL_TD);
    }

    @Override
    public boolean disableIfAttributesWerePushed() {
        return this.getBooleanValue(CFG_DISABLE_PULL_WHEN_PUSHED);
    }

    @Override
    public X509CertChainValidator getAssertionIssuerValidator() {
        return this.trustProperties.getValidator();
    }

    public Properties getSourceProperties() {
        return this.properties;
    }

    static {
        PropertyMD.DocumentationCategory pullCat = new PropertyMD.DocumentationCategory("Pull mode");
        PropertyMD.DocumentationCategory pushCat = new PropertyMD.DocumentationCategory("Push mode");
        PropertyMD.DocumentationCategory mainCat = new PropertyMD.DocumentationCategory("General");
        DEFAULTS.put(CFG_DISABLE_PULL_WHEN_PUSHED, new PropertyMD("true").setCategory(pullCat).setDescription("Whether pull mode should be skipped if user sent (or pushed) some attributes with the request. Note that to make this feature work PUSH mode must be enabled AND PULL authorization must be invoked AFTER PUSH authorization."));
        DEFAULTS.put(CFG_PULL_ENABLE, new PropertyMD("false").setCategory(pullCat).setDescription("Defines if pull mode should be enabled."));
        DEFAULTS.put(CFG_PULL_GENERIC_ENABLE, new PropertyMD("true").setCategory(pullCat).setDescription("If turned on, then not only the recognized UNICORE attributes are processed, but also all others, which can be used for authorization."));
        DEFAULTS.put(CFG_PULL_TD, new PropertyMD("true").setCategory(pullCat).setDescription("If you enable trust delegation support then attributes will be pulled on behalf of the caller (of course if he/she delegated his/her trust to this service). This is useful as then there is no need to add this server's identity to the VO service and assign read permissions to it (by default everybody can read her/his own data)."));
        DEFAULTS.put(CFG_SERVER_URI, new PropertyMD().setCategory(pullCat).setDescription("Should contain this server URI. It is REQUIRED if pull mode is enabled, and is used to identify this server to the VO service. In push mode it is used as this server actor's name (note that assertions in WS security element with no actor set are also used)."));
        DEFAULTS.put(CFG_VO_PULL_CACHE, new PropertyMD("600").setCategory(pullCat).setDescription("Controls pulled attributes cache. Set to negative integer to disable the caching or to positive number - lifetime in seconds of cached entries."));
        DEFAULTS.put(CFG_VO_SERVICE_HOST, new PropertyMD("localhost").setCategory(pullCat).setDescription("Address of SAML VO service host. Note that this server's CA cert must be present in the main truststore of the server to create the connection."));
        DEFAULTS.put(CFG_VO_SERVICE_PATH, new PropertyMD("").setCategory(pullCat).setDescription("If using UVOS as a service you can leave this field empty. Otherwise specify correct path part of VO service URI."));
        DEFAULTS.put(CFG_VO_SERVICE_PORT, new PropertyMD("2443").setBounds(1L, 65535L).setCategory(pullCat).setDescription("Port of SAML VO service."));
        DEFAULTS.put(CFG_VO_VERIFY_SIGNATURES, new PropertyMD("true").setCategory(pullCat).setDescription("Additional security for the pulled assertions (except transport level which is always on) can be achieved by verification of signatures of the received assertions. The key which is used for verification must be present in the VO truststore."));
        DEFAULTS.put(CFG_PUSH_ENABLE, new PropertyMD("false").setCategory(pushCat).setDescription("Defines if push mode should be enabled."));
        DEFAULTS.put(CFG_VO_SERVICE_SCOPE, new PropertyMD().setCategory(mainCat).setDescription("VO or group which is accepted by this attribute source. Server will honour only attributes with exactly this scope or global (i.e. without scope set)."));
        DEFAULTS.put(CFG_VO_SERVICE_URI, new PropertyMD().setCategory(mainCat).setDescription("Identification URI of the VO service providing attribtues for this source. Only attributes issued by this issuer will be honoured."));
        DEFAULTS.put("truststore.", new PropertyMD().setCanHaveSubkeys().setCategory(mainCat).setDescription("Properties starting with this prefix are used to configure validation of VO assertion issuers certificates. Trust anchors should contain only the trusted VO servers certificates. All options are the same as those for other UNICORE truststores."));
        DEFAULTS.put(CFG_INCARNATION_ATTR_PFX, new PropertyMD().setCanHaveSubkeys().setCategory(mainCat).setDescription("Properties starting with this prefix are used to configure mappings of SAML attributes to UNICORE internal ones."));
    }
}

