/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.uas.security.vo;

import eu.unicore.security.XACMLAttribute;
import eu.unicore.util.Log;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import pl.edu.icm.unicore.uvos.api.Attribute;

public class XACMLAttributesExtractor {
    private static final Logger logger = Log.getLogger((String)"unicore.security.vocommon", XACMLAttributesExtractor.class);

    public static List<XACMLAttribute> getSubjectAttributes(List<Attribute> authzAttribs, String scope) {
        logger.debug((Object)"getSubjectAttributes called");
        if (authzAttribs == null) {
            return null;
        }
        ArrayList<XACMLAttribute> ret = new ArrayList<XACMLAttribute>();
        try {
            for (Attribute voAttr : authzAttribs) {
                if (!XACMLAttributesExtractor.hasProperScope(voAttr, scope)) continue;
                XACMLAttributesExtractor.map2XACMLAttr(ret, voAttr);
            }
        }
        catch (URISyntaxException e) {
            logger.warn((Object)("Name or value of attribute received was not a URI and it was supposed to be it. Message is: " + e));
            return null;
        }
        return ret;
    }

    protected static boolean hasProperScope(Attribute a, String scope) {
        String s = a.getScope();
        if (s == null || scope == null || s.equals(scope.toString())) {
            return true;
        }
        logger.debug((Object)("Ignoring attribute " + a.getName() + " as it has unwanted" + " scope: " + s));
        return false;
    }

    private static void map2XACMLAttr(List<XACMLAttribute> toFill, Attribute voAttr) throws URISyntaxException {
        String xacmlDT = voAttr.getType().getDataType();
        if (xacmlDT == null) {
            logger.debug((Object)("Got SAML attribute without XACML DT set - ignoring, it's name is: " + voAttr.getName()));
            return;
        }
        if (xacmlDT.equals("http://www.w3.org/2001/XMLSchema#string")) {
            for (String value : voAttr.getValues()) {
                logger.debug((Object)("Adding XACML string attribute " + voAttr.getName() + " with value " + value));
                toFill.add(new XACMLAttribute(voAttr.getName(), value, XACMLAttribute.Type.STRING));
            }
        } else if (xacmlDT.equals("http://www.w3.org/2001/XMLSchema#anyURI")) {
            for (String value : voAttr.getValues()) {
                logger.debug((Object)("Adding XACML anyURI attribute " + voAttr.getName() + " with value " + value));
                toFill.add(new XACMLAttribute(voAttr.getName(), value, XACMLAttribute.Type.ANYURI));
            }
        } else if (xacmlDT.equals("urn:SAML:voprofile:ScopedAttribute")) {
            Iterator i$ = voAttr.getValues().iterator();
            while (i$.hasNext()) {
                String value;
                String val = value = (String)i$.next();
                if (voAttr.getScope() != null && !voAttr.getScope().equals("/")) {
                    val = val + "@" + voAttr.getScope();
                }
                logger.debug((Object)("Adding XACML scoped string attribute " + voAttr.getName() + " with value " + val + " as a normal string attribute"));
                toFill.add(new XACMLAttribute(voAttr.getName(), val, XACMLAttribute.Type.STRING));
            }
        } else {
            logger.warn((Object)("Got SAML attribute with unsupported XACML DataType: " + xacmlDT + ". Attribute name is: " + voAttr.getName()));
            return;
        }
    }
}

