/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.uas.security.vo;

import de.fzj.unicore.wsrflite.Kernel;
import eu.unicore.security.SecurityTokens;
import eu.unicore.security.SubjectAttributesHolder;
import eu.unicore.uas.security.vo.SAMLAttributeSourceBase;
import eu.unicore.uas.security.vo.VOAttributeFetcher;
import eu.unicore.uas.security.vo.conf.PullConfigurationHelper;
import eu.unicore.util.Log;
import eu.unicore.util.configuration.ConfigurationException;
import eu.unicore.util.httpclient.IClientConfiguration;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import pl.edu.icm.unicore.uvos.api.Attribute;

public class SAMLPullAuthoriser
extends SAMLAttributeSourceBase {
    private static final Logger log = Log.getLogger((String)"unicore.security.vo.pull", SAMLPullAuthoriser.class);
    private VOAttributeFetcher fetcher;

    public void configure(String name) throws ConfigurationException {
        this.initConfig(log, name, false);
    }

    public void start(Kernel kernel) throws Exception {
        this.kernel = kernel;
        if (!this.isEnabled) {
            return;
        }
        try {
            this.fetcher = new VOAttributeFetcher(this.conf, (IClientConfiguration)kernel.getClientConfiguration());
        }
        catch (Exception e) {
            this.isEnabled = false;
            log.error((Object)("Error in VO subsystem configuration (PULL mode): " + e.toString() + "\n PULL MODE WILL BE DISABLED"));
        }
        super.initFinal(log, "SAMLPullAuthoriser_ALLpulledattrs", false);
    }

    public SubjectAttributesHolder getAttributes(SecurityTokens tokens, SubjectAttributesHolder otherAuthoriserInfo) throws IOException {
        if (!this.isEnabled) {
            return new SubjectAttributesHolder();
        }
        this.fetcher.authorise(tokens);
        Map allAttributes = (Map)tokens.getContext().get("SAMLPullAuthoriser_ALLpulledattrs");
        List serviceAttributesOrig = (List)allAttributes.get(PullConfigurationHelper.getVOServiceAddress(this.conf.getVOServiceHost(), this.conf.getVOServicePort(), this.conf.getVOServicePath()));
        ArrayList<Object> serviceAttributes = serviceAttributesOrig != null ? new ArrayList(serviceAttributesOrig) : new ArrayList<Attribute>();
        return this.assembleAttributesHolder(serviceAttributes, otherAuthoriserInfo, this.conf.isPulledGenericAttributesEnabled());
    }

    public String getStatusDescription() {
        return "SAML Pull Attribute source [" + this.name + "]: " + (this.isEnabled ? "OK" : "DISABLED (browse previous log entries for the reason)");
    }
}

