/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.uas.security.vo;

import de.fzj.unicore.wsrflite.Kernel;
import de.fzj.unicore.wsrflite.security.IAttributeSource;
import de.fzj.unicore.wsrflite.security.VODescription;
import de.fzj.unicore.wsrflite.security.util.AttributeHandlingCallback;
import eu.unicore.security.SubjectAttributesHolder;
import eu.unicore.security.XACMLAttribute;
import eu.unicore.uas.security.vo.AttributesCallback;
import eu.unicore.uas.security.vo.UnicoreAttributeMappingDef;
import eu.unicore.uas.security.vo.UnicoreAttributesHandler;
import eu.unicore.uas.security.vo.UnicoreIncarnationAttributes;
import eu.unicore.uas.security.vo.VOCommonUtils;
import eu.unicore.uas.security.vo.XACMLAttributesExtractor;
import eu.unicore.uas.security.vo.conf.PropertiesBasedConfiguration;
import eu.unicore.util.configuration.ConfigurationException;
import java.io.IOException;
import java.util.List;
import org.apache.log4j.Logger;
import pl.edu.icm.unicore.uvos.api.Attribute;

public abstract class SAMLAttributeSourceBase
implements IAttributeSource {
    protected PropertiesBasedConfiguration conf;
    protected UnicoreAttributesHandler specialAttrsHandler;
    protected String configFile;
    protected String name;
    protected boolean isEnabled;
    protected Kernel kernel;

    protected void initConfig(Logger log, String name, boolean pushMode) {
        this.name = name;
        this.isEnabled = false;
        try {
            this.conf = new PropertiesBasedConfiguration(this.configFile);
        }
        catch (IOException e) {
            throw new ConfigurationException("Can't read configuration of the VO subsystem: " + e.getMessage());
        }
        if (pushMode && !this.conf.isPushEnabled()) {
            return;
        }
        if (!pushMode && !this.conf.isPullEnabled()) {
            return;
        }
        this.isEnabled = true;
    }

    protected void initFinal(Logger log, String key, boolean pushMode) {
        log.info((Object)"Adding VO attributes callbacks");
        AttributesCallback callback = new AttributesCallback(key, this.name);
        this.kernel.getSecurityManager().addCallback((AttributeHandlingCallback)callback);
        UnicoreAttributeMappingDef[] initializedMappings = VOCommonUtils.fillMappings(this.conf.getSourceProperties(), VOCommonUtils.mappings, log);
        if (log.isDebugEnabled()) {
            log.debug((Object)VOCommonUtils.createMappingsDesc(initializedMappings));
        }
        this.specialAttrsHandler = new UnicoreAttributesHandler(this.conf, initializedMappings, pushMode);
    }

    protected SubjectAttributesHolder assembleAttributesHolder(List<Attribute> serviceAttributes, SubjectAttributesHolder otherAuthoriserInfo, boolean addGeneric) {
        List<XACMLAttribute> xacmlAttributes;
        SubjectAttributesHolder ret = new SubjectAttributesHolder(otherAuthoriserInfo.getPreferredVos());
        String preferredScope = VOCommonUtils.handlePreferredVo(otherAuthoriserInfo.getPreferredVos(), this.conf.getScope(), otherAuthoriserInfo.getSelectedVo());
        UnicoreIncarnationAttributes uia = this.specialAttrsHandler.extractUnicoreAttributes(serviceAttributes, preferredScope, true);
        if (addGeneric && (xacmlAttributes = XACMLAttributesExtractor.getSubjectAttributes(serviceAttributes, this.conf.getScope())) != null) {
            ret.setXacmlAttributes(xacmlAttributes);
        }
        if (uia.getDefaultAttributes() != null && uia.getValidAttributes() != null) {
            ret.setAllIncarnationAttributes(uia.getDefaultAttributes(), uia.getValidAttributes());
        }
        if (uia.getDefaultVoAttributes() != null && preferredScope != null && ret.getValidIncarnationAttributes() != null) {
            String[] usersVos;
            for (String userVo : usersVos = (String[])ret.getValidIncarnationAttributes().get("virtualOrganisations")) {
                if (!userVo.equals(preferredScope)) continue;
                ret.setPreferredVoIncarnationAttributes(preferredScope, uia.getDefaultVoAttributes());
                break;
            }
        }
        return ret;
    }

    public void setConfigurationFile(String configFile) {
        this.configFile = configFile;
    }

    public String getConfigurationFile() {
        return this.configFile;
    }

    public String getName() {
        return this.name;
    }

    public VODescription[] getAcceptedVOs() {
        if (this.conf.isPullEnabled() || this.conf.isPushEnabled()) {
            VODescription supported = new VODescription(this.conf.getScope(), this.conf.getVOServiceURI());
            return new VODescription[]{supported};
        }
        return new VODescription[0];
    }
}

