/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.uas.security.vo;

import eu.emi.security.authn.x509.X509CertChainValidator;
import eu.emi.security.authn.x509.impl.X500NameUtils;
import eu.unicore.samly2.assertion.Assertion;
import eu.unicore.samly2.exceptions.SAMLParseException;
import eu.unicore.security.SecurityTokens;
import eu.unicore.security.dsig.DSigException;
import eu.unicore.security.xfireutil.AuthInHandler;
import eu.unicore.security.xfireutil.ETDInHandler;
import eu.unicore.security.xfireutil.WSSecHeader;
import eu.unicore.uas.security.vo.conf.IPushConfiguration;
import eu.unicore.uas.security.vo.conf.PushConfigurationHelper;
import eu.unicore.util.Log;
import java.io.IOException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.security.auth.x500.X500Principal;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlOptions;
import org.codehaus.xfire.MessageContext;
import org.codehaus.xfire.handler.AbstractHandler;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.output.XMLOutputter;
import pl.edu.icm.unicore.uvos.wsapi.xmlbeans.SAMLXMLBeansMapper;
import pl.edu.icm.unicore.uvos.wsapi.xmlbeans.UnsupportedSAMLException;
import xmlbeans.org.oasis.saml2.assertion.AssertionDocument;
import xmlbeans.org.oasis.saml2.assertion.AttributeStatementType;
import xmlbeans.org.oasis.saml2.assertion.AttributeType;
import xmlbeans.org.oasis.saml2.assertion.NameIDType;

public class SAMLAttributePushInHandler
extends AbstractHandler {
    private static final Logger log = Log.getLogger((String)"unicore.security.vo.push", SAMLAttributePushInHandler.class);
    public static final Namespace SAML2_NS = Namespace.getNamespace((String)"urn:oasis:names:tc:SAML:2.0:assertion");
    public static final String PUSHED_ATTRS_KEY = "SAMLPushedattrs";
    protected IPushConfiguration conf;
    protected boolean enabled = false;
    protected String actor;

    public SAMLAttributePushInHandler(IPushConfiguration cc) throws Exception {
        this.setPhase("policy");
        this.after(AuthInHandler.class.getName());
        this.after(ETDInHandler.class.getName());
        PushConfigurationHelper helper = new PushConfigurationHelper(cc);
        this.enabled = helper.isPushEnabled();
        if (!this.enabled) {
            return;
        }
        this.conf = cc;
        this.actor = helper.getActor();
    }

    public void invoke(MessageContext context) throws Exception {
        if (!this.enabled || context.getContextualProperty("client.mode") != null) {
            return;
        }
        log.debug((Object)"SAML AttributePushInHandler INVOKED");
        SecurityTokens t = (SecurityTokens)context.getProperty(SecurityTokens.KEY);
        if (t == null) {
            log.error((Object)("No Security tokens found, skipping message. Handlers configuration is propably incorrect: this handler should be used after " + AuthInHandler.class.getName()));
            return;
        }
        X500Principal principal = t.getEffectiveUserName();
        if (principal == null) {
            log.warn((Object)"No effective user info found, skipping the message.");
            return;
        }
        Map ctx = t.getContext();
        List<Assertion> toBeAdded = (List<Assertion>)ctx.get("SAMLPushedassertions");
        if (toBeAdded != null) {
            log.warn((Object)(SAMLAttributePushInHandler.class.getName() + " configured more then once, this doesn't make sense"));
            return;
        }
        toBeAdded = this.extractCorrectOnes(context.getInMessage().getHeader(), principal);
        ctx.put("SAMLPushedassertions", toBeAdded);
        if (toBeAdded.size() > 0) {
            HashMap attrsByIssuer = new HashMap();
            for (Assertion a : toBeAdded) {
                NameIDType issuer = a.getXML().getAssertion().getIssuer();
                if (issuer == null || issuer.getStringValue() == null) {
                    log.error((Object)"Received an assertion without issuer set. This is not supported, the assertion will be ignored. The assertion is logged on DEBUG level.");
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("No issuer assertion:\n" + a.getXML().xmlText()));
                    continue;
                }
                ArrayList<pl.edu.icm.unicore.uvos.api.Attribute> attrs = new ArrayList<pl.edu.icm.unicore.uvos.api.Attribute>();
                try {
                    attrs.addAll(this.convertToAttributes(a, ctx));
                    attrsByIssuer.put(issuer.getStringValue(), attrs);
                }
                catch (Exception e) {
                    log.info((Object)"Can't parse some of received attributes (won't be used for authorization): ", (Throwable)e);
                }
            }
            if (attrsByIssuer.size() > 0) {
                ctx.put(PUSHED_ATTRS_KEY, attrsByIssuer);
            }
        }
    }

    public QName[] getUnderstoodHeaders() {
        return new QName[]{new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Security")};
    }

    private List<Assertion> extractCorrectOnes(Element header, X500Principal principal) {
        ArrayList<Assertion> verifiedAssertions = new ArrayList<Assertion>();
        if (header == null) {
            log.debug((Object)"No SOAP header");
            return verifiedAssertions;
        }
        Element wsSecEl = null;
        if (this.actor != null) {
            WSSecHeader utilActor = new WSSecHeader(this.actor, true);
            wsSecEl = utilActor.findWSSecElement(header);
        }
        if (wsSecEl == null) {
            WSSecHeader utilNoActor = new WSSecHeader(true);
            wsSecEl = utilNoActor.findWSSecElement(header);
        }
        if (wsSecEl == null) {
            log.debug((Object)"No valid WS Security element found in SOAP header");
            return verifiedAssertions;
        }
        List assertions = wsSecEl.getChildren("Assertion", SAML2_NS);
        if (assertions.size() == 0) {
            log.debug((Object)"No assertion found");
            return verifiedAssertions;
        }
        for (Object assertionO : assertions) {
            Element assertion = (Element)assertionO;
            Assertion goodAssertion = this.checkAndParse(assertion, principal);
            if (goodAssertion == null) continue;
            verifiedAssertions.add(goodAssertion);
        }
        return verifiedAssertions;
    }

    private Assertion checkAndParse(Element assertion, X500Principal principal) {
        Element as = assertion.getChild("AttributeStatement", SAML2_NS);
        if (as == null) {
            return null;
        }
        List attrs = as.getChildren("Attribute", SAML2_NS);
        for (Object obj2 : attrs) {
            String val;
            Element attr = (Element)obj2;
            Attribute nFormat = attr.getAttribute("NameFormat");
            if (nFormat == null || !(val = nFormat.getValue()).equals("urn:unicore:subject-role") && !val.equals("urn:unicore:subject-role")) continue;
            log.debug((Object)"Ignoring generic UNICORE 6 security header");
            return null;
        }
        Assertion paAssertion = this.parseAssertion(assertion);
        if (paAssertion == null) {
            return null;
        }
        if (!this.checkAssertionSubject(paAssertion, principal)) {
            return null;
        }
        X509Certificate issuer = this.checkAssertionValidity(paAssertion);
        if (issuer == null) {
            return null;
        }
        return paAssertion;
    }

    private Assertion parseAssertion(Element assertion) {
        XMLOutputter outputter = new XMLOutputter();
        try {
            String jdomAssertion = outputter.outputString(assertion);
            AssertionDocument asDoc = AssertionDocument.Factory.parse((String)jdomAssertion);
            if (log.isTraceEnabled()) {
                log.trace((Object)("CHECKING ASSERTION: " + asDoc.xmlText(new XmlOptions().setSavePrettyPrint())));
            }
            return new Assertion(asDoc);
        }
        catch (XmlException e) {
            log.debug((Object)("Assertion ignored (XML parsing exception): " + (Object)((Object)e)));
            return null;
        }
        catch (SAMLParseException e) {
            log.debug((Object)("Assertion ignored (assertion parsing exception): " + (Object)((Object)e)));
            return null;
        }
        catch (IOException e) {
            log.debug((Object)("Assertion ignored (IO exception): " + e));
            return null;
        }
    }

    private boolean checkAssertionSubject(Assertion paAssertion, X500Principal principal) {
        String subjectDN = paAssertion.getSubjectDN();
        if (subjectDN == null) {
            log.warn((Object)"Assertion subject is not a DN");
            return false;
        }
        if (!X500NameUtils.equal((X500Principal)principal, (String)subjectDN)) {
            log.debug((Object)("Assertion in header is issued for other subject then the User's. User's DN: " + X500NameUtils.getReadableForm((X500Principal)principal) + "   Subject's DN: " + X500NameUtils.getReadableForm((String)subjectDN)));
            return false;
        }
        log.debug((Object)("Subject's DN: " + subjectDN));
        return true;
    }

    private X509Certificate checkAssertionValidity(Assertion paAssertion) {
        if (!paAssertion.checkTimeConditions()) {
            log.info((Object)"Assertion is EXPIRED, ignoring");
            return null;
        }
        log.debug((Object)"Assertion is in time rage");
        if (!paAssertion.isSigned()) {
            log.info((Object)"Assertion is unsigned - ignoring");
            return null;
        }
        X509Certificate[] certs = paAssertion.getIssuerFromSignature();
        if (certs == null || certs.length == 0) {
            log.info((Object)"Assertion is signed but there is no Issuer's certificate included - ignoring");
            return null;
        }
        try {
            X509CertChainValidator validator = this.conf.getAssertionIssuerValidator();
            if (!this.checkIfTrusted(validator, certs)) {
                log.info((Object)("Assertion was issued by an entity which is not trusted as VO authority: " + X500NameUtils.getReadableForm((X500Principal)certs[0].getSubjectX500Principal())));
                return null;
            }
            if (!paAssertion.isCorrectlySigned(certs[0].getPublicKey())) {
                log.info((Object)"Assertion signature is INVALID, skipping");
                return null;
            }
            log.debug((Object)"Assertion signature is correct.");
        }
        catch (DSigException e) {
            log.info((Object)("Problem occured when checking a signature (assertion will be skipped): " + (Object)((Object)e)));
            return null;
        }
        return certs[0];
    }

    private boolean checkIfTrusted(X509CertChainValidator validator, X509Certificate[] issuersCC) {
        X509Certificate[] trustedIssuers = validator.getTrustedIssuers();
        boolean found = false;
        for (X509Certificate trusted : trustedIssuers) {
            if (!trusted.equals(issuersCC[0])) continue;
            found = true;
            break;
        }
        return found;
    }

    private List<pl.edu.icm.unicore.uvos.api.Attribute> convertToAttributes(Assertion assertion, Map<String, Object> special) throws UnsupportedSAMLException, SAMLParseException {
        AttributeStatementType[] xmlAttrStatements;
        ArrayList<pl.edu.icm.unicore.uvos.api.Attribute> ret = new ArrayList<pl.edu.icm.unicore.uvos.api.Attribute>();
        for (AttributeStatementType xmlAttrStatement : xmlAttrStatements = assertion.getAttributes()) {
            AttributeType[] xmlAttrs;
            for (AttributeType xmlAttr : xmlAttrs = xmlAttrStatement.getAttributeArray()) {
                List attrs = SAMLXMLBeansMapper.map2APIAttributes((AttributeType)xmlAttr);
                for (pl.edu.icm.unicore.uvos.api.Attribute a : attrs) {
                    ret.add(a);
                }
            }
        }
        return ret;
    }
}

