/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.uas.security.vo;

import de.fzj.unicore.wsrflite.Kernel;
import de.fzj.unicore.wsrflite.security.ContainerSecurityProperties;
import de.fzj.unicore.wsrflite.security.IAttributeSource;
import de.fzj.unicore.wsrflite.security.util.AttributeSourcesChain;
import eu.unicore.uas.security.vo.SAMLPullAuthoriser;
import eu.unicore.uas.security.vo.conf.PropertiesBasedConfiguration;
import eu.unicore.uas.security.vo.conf.PullConfigurationHelper;
import eu.unicore.util.configuration.FilePropertiesHelper;
import eu.unicore.util.httpclient.IClientConfiguration;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.List;
import pl.edu.icm.unicore.uvos.api.Element;
import pl.edu.icm.unicore.uvos.api.Group;
import pl.edu.icm.unicore.uvos.api.Identity;
import pl.edu.icm.unicore.uvos.api.IdentityType;
import pl.edu.icm.unicore.uvos.api.exceptions.AuthenticationException;
import pl.edu.icm.unicore.uvos.api.exceptions.UVOSException;
import pl.edu.icm.unicore.uvos.wsclient.api.UVOSClientFactory;
import pl.edu.icm.unicore.uvos.wsclient.api.WSManagementClient;
import pl.edu.icm.unicore.uvos.wsclient.api.WSQueryClient;
import pl.edu.icm.unicore.uvos.wsclient.samlapi.SAMLVOQueryClient;

public class PullTester {
    private List<SAMLPullAuthoriser> list;
    private List<String> names;
    private IClientConfiguration secProps;

    private void checkUASConfig(String config) throws Exception {
        ContainerSecurityProperties csp = new ContainerSecurityProperties(FilePropertiesHelper.load((String)config));
        this.list = this.getAttributeSources(csp);
        if (this.list.size() == 0) {
            System.out.println("There is no " + SAMLPullAuthoriser.class.getName() + " attribute source configured in the " + config + " file.\n" + "Add it by choosing a label (e.g. 'VOPULL'), add this label to the" + " property " + "container.security." + "attributes.order" + " and define a property " + "container.security." + "attributes" + ".VOPULL.class=" + SAMLPullAuthoriser.class.getName());
            throw new Exception();
        }
    }

    private List<SAMLPullAuthoriser> getAttributeSources(ContainerSecurityProperties p) throws Exception {
        IAttributeSource aip = p.getAip();
        ArrayList<SAMLPullAuthoriser> authChain = new ArrayList<SAMLPullAuthoriser>();
        if (aip instanceof AttributeSourcesChain) {
            this.extractAipsRec(authChain, (AttributeSourcesChain)aip);
        }
        return authChain;
    }

    private void extractAipsRec(List<SAMLPullAuthoriser> authChain, AttributeSourcesChain chain) {
        List elements = chain.getChain();
        for (IAttributeSource aip : elements) {
            if (aip instanceof SAMLPullAuthoriser) {
                authChain.add((SAMLPullAuthoriser)aip);
            }
            if (!(aip instanceof AttributeSourcesChain)) continue;
            this.extractAipsRec(authChain, (AttributeSourcesChain)aip);
        }
    }

    private static PropertiesBasedConfiguration configureVO(String configFile) throws Exception {
        try {
            PropertiesBasedConfiguration propsConfig = configFile != null ? new PropertiesBasedConfiguration(configFile) : new PropertiesBasedConfiguration();
            return propsConfig;
        }
        catch (FileNotFoundException e) {
            System.out.println("VO configuration file was not found: " + e.getMessage());
            throw e;
        }
        catch (IOException e) {
            System.out.println("Input/Output error when reading VO configuration file: " + e.getMessage());
            throw e;
        }
    }

    private static IClientConfiguration configureWSRFLite(String configFile) throws Exception {
        Kernel k = new Kernel(configFile);
        return k.getClientConfiguration();
    }

    private static PullConfigurationHelper getHelper(PropertiesBasedConfiguration voCfg, IClientConfiguration secProps) throws Exception {
        PullConfigurationHelper pullHelper = null;
        try {
            pullHelper = new PullConfigurationHelper(voCfg, secProps);
        }
        catch (Exception e) {
            System.out.println("Error occured when reading initial VO configuration.\nIt usually means that VO truststore is misconfigured.\nThe error was: " + e);
            throw e;
        }
        if (!pullHelper.isPullEnabled()) {
            System.out.println("Pull mode is not enabled in vo configuration file or there is an other fundamental error in configuration (then you should get its description just above)");
            throw new Exception();
        }
        return pullHelper;
    }

    private static WSQueryClient checkConnection(PullConfigurationHelper pullHelper, IClientConfiguration secProps) throws Exception {
        String addr = pullHelper.getVOServiceAddress();
        System.out.println("      UVOS server URL is: " + addr);
        UVOSClientFactory cliFactory = new UVOSClientFactory(secProps);
        try {
            WSManagementClient manClient = cliFactory.getWSManagementClientHL(addr);
            manClient.getIdentityTypes();
            return cliFactory.getWSQueryClientHL(addr);
        }
        catch (MalformedURLException e) {
            System.out.println("UVOS server address is not a valid URI: " + e);
            throw e;
        }
        catch (AuthenticationException e) {
            if (pullHelper.isPulledTDEnabled()) {
                System.out.println("UVOS server returned an authentication error. As you have enabled trust delegation support it may be perfectly OK. However you must ensure that CA which issued this server's certificate is actually trusted by the UVOS server.\n Note that with the current setup PULL mode will fail if you turn off the trust delegation.");
                return null;
            }
            System.out.println("UVOS server returned an authentication error. Usually it means that CA that issued this server's certificate is not trusted by UVOS server or that this server's identity is not present in UVOS service.");
            throw e;
        }
        catch (UVOSException e) {
            System.out.println("UVOS server returned an error. Consult above messages and the following error information for further information.\n\nThe error was: " + (Object)((Object)e));
            throw e;
        }
        catch (Exception e) {
            System.out.println("Can't create connection to UVOS server. The most probable reasons are:\n incorrect UVOS address, the UVOS server is down, CA which issued UVOS server's certificate is not in local Unicore/X truststore or CA that issued this server's certificated is not in UVOS truststore.\n\nThe error was: " + e);
            throw e;
        }
    }

    private static void doPermTest(PullConfigurationHelper pullHelper, String scopeS, WSQueryClient qCli) throws Exception {
        List elements;
        if (scopeS == null) {
            System.out.println("There is no group defined where attributes used by this  server are defined. In some extremely rare cases it may be a valid setup (when your grid uses only global attributes and you don't want to use xlogins/roles stored on VO server) however we are unable to complete tests in this case.");
            return;
        }
        Group scope = new Group(scopeS);
        System.out.println("Configured group is: " + scope.toString());
        try {
            elements = qCli.getGroupContent(scope);
        }
        catch (UVOSException e) {
            System.out.println("Couldn't read group contents. It means that either the group doesn't exist or that this server has no read permission to that group. The error is: " + (Object)((Object)e));
            throw e;
        }
        System.out.println("Successfully read group contents. Everything should be ok from now, we will do only some final checks....");
        if (elements.size() == 0) {
            System.out.println("Group is readable but is empty. UVOS administrator should add members to the group (or you should use another group)");
            return;
        }
        Identity toCheck = null;
        for (Element e : elements) {
            if (!e.getIdentity().getType().equals((Object)IdentityType.DN) && !e.getIdentity().getType().equals((Object)IdentityType.X509CERT)) continue;
            toCheck = e.getIdentity();
            break;
        }
        if (toCheck == null) {
            System.out.println("Group is readable but has no members with either X509 certificates or DNs. UVOS administrator should add members of those formats to the group (or you should use another group)");
            return;
        }
        SAMLVOQueryClient client = pullHelper.createClient();
        try {
            client.getAttributes(toCheck, scope);
        }
        catch (Exception e1) {
            System.out.println("Bad! Couldn't get attributes of the group member via SAML protocol. Usually it shouldn't happen. Error was: " + e1);
            throw e1;
        }
        System.out.println("OK\n\nTEST PASSED SUCCESSFULY");
    }

    public void testAttributeSource(SAMLPullAuthoriser pullAuthz, String name) throws Exception {
        System.out.println("\n   ** Testing " + name);
        PropertiesBasedConfiguration voCfg = PullTester.configureVO(pullAuthz.getConfigurationFile());
        String voCfgFile = pullAuthz.getConfigurationFile();
        if (voCfgFile == null) {
            voCfgFile = "conf/vo.config";
        }
        System.out.print("   -> Parsing configuration file " + voCfgFile + ": ");
        System.out.flush();
        PullConfigurationHelper pullHelper = PullTester.getHelper(voCfg, this.secProps);
        System.out.println("OK\n");
        System.out.println("   -> Checking connection to UVOS server:");
        WSQueryClient qCli = PullTester.checkConnection(pullHelper, this.secProps);
        System.out.println("      OK\n");
        if (voCfg.enableTD()) {
            System.out.println("\n   Trust delegation support is enabled in your\n   configuration file. This means that everything should work\n   assuming that you have entered a right group in your\n   configuration file and that proper attributes are assigned\n   in UVOS server.\n\n   TEST PASSED SUCCESSFULY");
            return;
        }
        System.out.println("\n   Trust delegation support is disabled in your configuration file.\n   We will perform additional tests to check if this server has\n   proper permissions to read users' data from the UVOS server.\n");
        System.out.println("   -> Checking read permissions:\n");
        PullTester.doPermTest(pullHelper, voCfg.getScope(), qCli);
    }

    public void doTest(String uasConfig) {
        try {
            System.out.print("-> Step 1: Trying to load container configuration: ");
            System.out.flush();
            this.secProps = PullTester.configureWSRFLite(uasConfig);
            System.out.println("OK\n");
            System.out.print("-> Step 2: Trying to find SAML PULL Attribute Sources: ");
            System.out.flush();
            this.checkUASConfig(uasConfig);
            System.out.println("OK\n");
            System.out.println("   Found the following PULL Attribute Sources:");
            for (String pullA : this.names) {
                System.out.println("   - " + pullA);
            }
            System.out.println();
            System.out.println("\n-> Step 3: Testing each Attribute Source in turn:");
            for (int i = 0; i < this.names.size(); ++i) {
                this.testAttributeSource(this.list.get(i), this.names.get(i));
            }
        }
        catch (Exception e) {
            System.err.println("Found a problem: " + e.toString());
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            System.out.println("This program allows you to test if VO subsystem is set up correctly.\nIt only tests PULL mode (push mode is much easier to be configured).\n\nUsage:\n  voPullTester.sh <UAS.CONFIG path>");
            return;
        }
        PullTester tester = new PullTester();
        tester.doTest(args[0]);
        System.exit(0);
    }
}

