/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.uas.security.ldap;

import java.util.HashSet;
import java.util.Set;

public class JMXStats {
    private int totalAuth = 0;
    private int cacheHits = 0;
    private float meanAccessTime = 0.0f;
    private Set<String> accessorNames = new HashSet<String>();

    public synchronized void incTotalAuth() {
        ++this.totalAuth;
    }

    public synchronized void incCacheHits() {
        ++this.cacheHits;
    }

    public synchronized void addAccessor(String name) {
        this.accessorNames.add(name);
    }

    public synchronized void publishTime(long time) {
        this.meanAccessTime = (this.meanAccessTime * (float)(this.totalAuth - 1) + (float)time) / (float)this.totalAuth;
    }

    public synchronized void clearStatistics() {
        this.totalAuth = 0;
        this.meanAccessTime = 0.0f;
        this.cacheHits = 0;
        this.accessorNames.clear();
    }

    public synchronized void clearRequestorNames() {
        this.accessorNames.clear();
    }

    public synchronized int getTotalRequests() {
        return this.totalAuth;
    }

    public synchronized int getCacheHits() {
        return this.cacheHits;
    }

    public synchronized float getMeanProcessingTime() {
        return this.meanAccessTime;
    }

    public synchronized String[] getRequestorNames() {
        return this.accessorNames.toArray(new String[this.accessorNames.size()]);
    }
}

