/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.uas.security.file;

import de.fzj.unicore.wsrflite.security.IAttributeSource;
import eu.emi.security.authn.x509.impl.CertificateUtils;
import eu.emi.security.authn.x509.impl.X500NameUtils;
import eu.unicore.security.SecurityTokens;
import eu.unicore.security.SubjectAttributesHolder;
import eu.unicore.security.XACMLAttribute;
import eu.unicore.uas.security.file.Attribute;
import eu.unicore.uas.security.file.FileAttributeSourceBase;
import eu.unicore.util.Log;
import eu.unicore.util.configuration.ConfigurationException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.security.auth.x500.X500Principal;
import org.apache.log4j.Logger;

public class X509FileAttributeSource
extends FileAttributeSourceBase
implements IAttributeSource {
    private static final Logger logger = Log.getLogger((String)"unicore.security", X509FileAttributeSource.class);
    private Map<X509Certificate, List<Attribute>> map;

    public X509FileAttributeSource() {
        super(logger);
    }

    private Map<X509Certificate, List<Attribute>> convert(Map<String, List<Attribute>> rawmap) throws IOException {
        HashMap<X509Certificate, List<Attribute>> result = new HashMap<X509Certificate, List<Attribute>>();
        for (Map.Entry<String, List<Attribute>> e : rawmap.entrySet()) {
            String key = e.getKey();
            ByteArrayInputStream is = new ByteArrayInputStream(key.getBytes());
            try {
                X509Certificate c = CertificateUtils.loadCertificate((InputStream)is, (CertificateUtils.Encoding)CertificateUtils.Encoding.PEM);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Loaded " + X500NameUtils.getReadableForm((X500Principal)c.getSubjectX500Principal())));
                }
                result.put(c, e.getValue());
            }
            catch (IOException ex) {
                throw new ConfigurationException("This key is invalid, should be a PEM certificate: " + key, (Throwable)ex);
            }
        }
        return result;
    }

    public SubjectAttributesHolder getAttributes(SecurityTokens tokens, SubjectAttributesHolder otherAuthoriserInfo) throws IOException {
        this.parseIfNeeded();
        X509Certificate subject = tokens.getEffectiveUserCertificate();
        if (subject == null) {
            logger.info((Object)("No effective user certificate found, won't assign any attributes from the certificate file attribute source. The client effective DN is: " + tokens.getEffectiveUserName()));
        }
        List<Attribute> attrs = this.searchFor(subject);
        HashMap<String, String[]> retAll = new HashMap<String, String[]>();
        HashMap<String, String[]> retFirst = new HashMap<String, String[]>();
        ArrayList<XACMLAttribute> retXACML = new ArrayList<XACMLAttribute>();
        if (attrs != null) {
            this.putAttributes(attrs, retAll, retFirst, retXACML);
        }
        return new SubjectAttributesHolder(retXACML, retFirst, retAll);
    }

    private List<Attribute> searchFor(X509Certificate cert) {
        return this.map.get(cert);
    }

    @Override
    protected void installNewMappings(Map<String, List<Attribute>> newData) throws ConfigurationException {
        try {
            this.map = this.convert(newData);
        }
        catch (Exception ex) {
            throw new ConfigurationException("Can't parse key(s) from the uudb file as certificates: " + ex, (Throwable)ex);
        }
    }

    public String getStatusDescription() {
        return "X509 File Attribute Source [" + this.getName() + "]: " + this.status + ", using map file " + this.uudbFile.getAbsolutePath();
    }
}

