/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.uas.security.file;

import de.fzj.unicore.wsrflite.Kernel;
import de.fzj.unicore.wsrflite.security.IAttributeSource;
import de.fzj.unicore.wsrflite.security.VODescription;
import eu.unicore.security.XACMLAttribute;
import eu.unicore.uas.security.file.Attribute;
import eu.unicore.uas.security.file.AttributesFileParser;
import eu.unicore.util.configuration.ConfigurationException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class FileAttributeSourceBase
implements IAttributeSource {
    private Logger logger;
    public static final String SPECIAL_XLOGIN = "xlogin";
    public static final String SPECIAL_ROLE = "role";
    public static final String SPECIAL_GROUP = "group";
    public static final String SPECIAL_SUP_GROUPS = "supplementaryGroups";
    public static final String SPECIAL_ADD_OS_GIDS = "addOsGroups";
    public static final String SPECIAL_QUEUE = "queue";
    private String name;
    protected long lastChanged;
    protected String status = "OK";
    protected File uudbFile = new File("conf", "simpleuudb");

    protected FileAttributeSourceBase(Logger logger) {
        this.logger = logger;
    }

    public void configure(String name) throws ConfigurationException {
        AttributesFileParser parser;
        this.name = name;
        try {
            parser = new AttributesFileParser(new FileInputStream(this.uudbFile));
        }
        catch (FileNotFoundException e1) {
            throw new ConfigurationException("The file " + this.uudbFile + " configured as an " + "input of attribute source " + name + " does not exists");
        }
        this.lastChanged = this.uudbFile.lastModified();
        try {
            this.installNewMappings(parser.parse());
        }
        catch (IOException e) {
            this.status = e.getMessage();
            throw new ConfigurationException("Error loading configuration of file attribute source " + name + ": " + e.toString(), (Throwable)e);
        }
    }

    public void start(Kernel kernel) throws Exception {
    }

    public String getName() {
        return this.name;
    }

    public void setFile(String uudbFile) {
        this.uudbFile = new File(uudbFile);
    }

    public VODescription[] getAcceptedVOs() {
        return null;
    }

    protected void putAttributes(List<Attribute> attrs, Map<String, String[]> allIncRet, Map<String, String[]> firstIncRet, List<XACMLAttribute> authzRet) {
        for (Attribute a : attrs) {
            String name = a.getName();
            boolean isIncarnation = true;
            if (name.equalsIgnoreCase(SPECIAL_XLOGIN)) {
                name = SPECIAL_XLOGIN;
            } else if (name.equalsIgnoreCase(SPECIAL_ROLE)) {
                name = SPECIAL_ROLE;
            } else if (name.equalsIgnoreCase(SPECIAL_GROUP)) {
                name = SPECIAL_GROUP;
            } else if (name.equalsIgnoreCase(SPECIAL_SUP_GROUPS)) {
                name = SPECIAL_SUP_GROUPS;
            } else if (name.equalsIgnoreCase(SPECIAL_ADD_OS_GIDS)) {
                name = "addDefaultGroups";
            } else if (name.equalsIgnoreCase(SPECIAL_QUEUE)) {
                name = SPECIAL_QUEUE;
            } else {
                isIncarnation = false;
            }
            if (isIncarnation) {
                if (!name.equals(SPECIAL_SUP_GROUPS)) {
                    if (a.getValues().size() > 0) {
                        firstIncRet.put(name, new String[]{a.getValues().get(0)});
                    } else {
                        firstIncRet.put(name, new String[0]);
                    }
                } else {
                    firstIncRet.put(name, a.getValues().toArray(new String[a.getValues().size()]));
                }
                allIncRet.put(name, a.getValues().toArray(new String[a.getValues().size()]));
                continue;
            }
            List<String> values = a.getValues();
            for (String value : values) {
                authzRet.add(new XACMLAttribute(name, value, XACMLAttribute.Type.STRING));
            }
            if (values.size() != 0) continue;
            throw new ConfigurationException("XACML Authorization attribute '" + name + "' defined without a value (file attribtue source " + this.getName() + ")");
        }
    }

    protected void parseIfNeeded() {
        long lastMod = this.uudbFile.lastModified();
        if (lastMod <= this.lastChanged) {
            return;
        }
        this.lastChanged = lastMod;
        try {
            AttributesFileParser parser = new AttributesFileParser(new FileInputStream(this.uudbFile));
            this.installNewMappings(parser.parse());
            this.logger.info((Object)("Updated user attributes were loaded from the file " + this.uudbFile));
        }
        catch (Exception e) {
            this.logger.error((Object)("The updated attributes list is INVALID: " + e.getMessage() + "\nWill continue to use the previously loaded one."));
        }
    }

    protected abstract void installNewMappings(Map<String, List<Attribute>> var1) throws ConfigurationException;
}

