/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unicore.uvos.wsclient.samlapi;

import eu.unicore.samly2.elements.NameID;
import eu.unicore.samly2.elements.NameIDPolicy;
import eu.unicore.samly2.exceptions.SAMLParseException;
import eu.unicore.samly2.proto.AbstractRequest;
import eu.unicore.samly2.proto.AbstractStatusResponse;
import eu.unicore.samly2.proto.NameIDMappingRequest;
import eu.unicore.samly2.proto.NameIDMappingResponse;
import eu.unicore.util.httpclient.IClientConfiguration;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.apache.xmlbeans.XmlCursor;
import pl.edu.icm.unicore.uvos.api.Identity;
import pl.edu.icm.unicore.uvos.api.IdentityType;
import pl.edu.icm.unicore.uvos.wsapi.xmlbeans.SAMLNameIdMappingInterface;
import pl.edu.icm.unicore.uvos.wsapi.xmlbeans.SAMLXMLBeansMapper;
import pl.edu.icm.unicore.uvos.wsapi.xmlbeans.UnsupportedSAMLException;
import pl.edu.icm.unicore.uvos.wsclient.samlapi.InvalidSignatureException;
import pl.edu.icm.unicore.uvos.wsclient.samlapi.InvocationException;
import pl.edu.icm.unicore.uvos.wsclient.samlapi.SAMLErrorResponseException;
import pl.edu.icm.unicore.uvos.wsclient.samlapi.SAMLVOClient;
import pl.edu.icm.unicore.uvos.wsclient.samlapi.SAMLVOMapClientInterface;
import pl.edu.icm.unicore.uvos.wsclient.samlapi.SecuritySetupException;
import xmlbeans.org.oasis.saml2.assertion.NameIDType;
import xmlbeans.org.oasis.saml2.protocol.ExtensionsType;
import xmlbeans.org.oasis.saml2.protocol.NameIDMappingResponseDocument;
import xmlbeans.org.oasis.saml2.protocol.NameIDMappingResponseType;
import xmlbeans.pl.edu.icm.samlvo.namemapext.AlternativeNameIDEntryType;
import xmlbeans.pl.edu.icm.samlvo.namemapext.AlternativeNameIDsType;

public class SAMLVOMapClient
extends SAMLVOClient
implements SAMLVOMapClientInterface {
    private SAMLNameIdMappingInterface mappingProxy;

    public SAMLVOMapClient(String address, IClientConfiguration secCfg) throws SecuritySetupException, MalformedURLException {
        super(address, secCfg);
        this.initProxy();
    }

    public SAMLVOMapClient(String address, IClientConfiguration secCfg, URI issuerURI) throws SecuritySetupException, MalformedURLException {
        super(address, secCfg, issuerURI);
        this.initProxy();
    }

    private void initProxy() {
        try {
            if (this.mappingProxy == null) {
                this.mappingProxy = this.fact.getSAMLIdMappingClient(this.address);
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    @Override
    public Identity mapIdentity(Identity toBeMapped, IdentityType mappedTo) throws InvocationException, InvalidSignatureException, SAMLParseException, SAMLErrorResponseException, UnsupportedSAMLException {
        List<Identity> list = this.mapIdentityGeneric(toBeMapped, mappedTo.getName().toString());
        if (list.size() == 0) {
            return null;
        }
        return list.get(0);
    }

    @Override
    public List<Identity> mapIdentity(Identity toBeMapped) throws InvalidSignatureException, InvocationException, SAMLParseException, SAMLErrorResponseException, UnsupportedSAMLException {
        return this.mapIdentityGeneric(toBeMapped, "urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified");
    }

    private List<Identity> mapIdentityGeneric(Identity toBeMapped, String format) throws InvalidSignatureException, InvocationException, SAMLParseException, SAMLErrorResponseException, UnsupportedSAMLException {
        NameID toMap = new NameID(toBeMapped.getValue(), toBeMapped.getType().getName().toString());
        NameIDPolicy policy = new NameIDPolicy(format);
        NameIDMappingRequest request = new NameIDMappingRequest(this.issuer, toMap, policy);
        this.signIfNeeded((AbstractRequest)request);
        NameIDMappingResponseDocument respDoc = null;
        try {
            respDoc = this.mappingProxy.mapNameId(request.getDoc());
            this.lastResponse = respDoc;
        }
        catch (Exception e) {
            throw new InvocationException(e);
        }
        NameIDMappingResponse resp = new NameIDMappingResponse(respDoc);
        resp.parse();
        if (!resp.isStatusOK()) {
            throw new SAMLErrorResponseException(resp.getErrorMessage(), resp.getErrorStatus(), resp.getSubErrorStatus());
        }
        this.checkResponseSignature((AbstractStatusResponse)resp);
        NameIDMappingResponseType rr = respDoc.getNameIDMappingResponse();
        Identity baseMap = SAMLXMLBeansMapper.map2APIIdentity((NameIDType)rr.getNameID());
        ArrayList<Identity> ret = new ArrayList<Identity>();
        ExtensionsType exts = rr.getExtensions();
        if (!this.addFromExts(ret, exts)) {
            ret.add(baseMap);
        }
        return ret;
    }

    private boolean addFromExts(List<Identity> ret, ExtensionsType exts) throws SAMLParseException {
        if (exts == null) {
            return false;
        }
        XmlCursor cur = exts.newCursor();
        if (!cur.toFirstChild()) {
            cur.dispose();
            return false;
        }
        do {
            if (!(cur.getObject() instanceof AlternativeNameIDsType)) continue;
            AlternativeNameIDsType allNames = (AlternativeNameIDsType)cur.getObject();
            cur.dispose();
            AlternativeNameIDEntryType[] entries = allNames.getMappedNameIDArray();
            if (entries == null) {
                return false;
            }
            for (AlternativeNameIDEntryType entry : entries) {
                Identity id = SAMLXMLBeansMapper.map2APIIdentity((NameIDType)entry.getNameID());
                ret.add(id);
            }
            return true;
        } while (cur.toNextSibling());
        cur.dispose();
        return false;
    }

    @Override
    public Object getProxy() {
        return this.mappingProxy;
    }
}

