/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unicore.uvos.wsclient;

import eu.unicore.samly2.elements.NameID;
import eu.unicore.samly2.elements.NameIDPolicy;
import eu.unicore.samly2.elements.SAMLAttribute;
import eu.unicore.samly2.elements.Subject;
import eu.unicore.samly2.proto.AttributeQuery;
import eu.unicore.samly2.proto.NameIDMappingRequest;
import eu.unicore.util.configuration.FilePropertiesHelper;
import eu.unicore.util.httpclient.IClientConfiguration;
import java.net.URI;
import java.util.List;
import java.util.Properties;
import org.apache.xmlbeans.XmlOptions;
import pl.edu.icm.unicore.uvos.api.Attribute;
import pl.edu.icm.unicore.uvos.api.AttributeType;
import pl.edu.icm.unicore.uvos.api.Group;
import pl.edu.icm.unicore.uvos.api.Identity;
import pl.edu.icm.unicore.uvos.api.IdentityType;
import pl.edu.icm.unicore.uvos.client.util.UVOSClientProperties;
import pl.edu.icm.unicore.uvos.wsapi.xmlbeans.SAMLNameIdMappingInterface;
import pl.edu.icm.unicore.uvos.wsapi.xmlbeans.SAMLQueryInterface;
import pl.edu.icm.unicore.uvos.wsclient.api.UVOSClientFactory;
import pl.edu.icm.unicore.uvos.wsclient.samlapi.SAMLVOClientInterface;
import pl.edu.icm.unicore.uvos.wsclient.samlapi.SAMLVOMapClient;
import pl.edu.icm.unicore.uvos.wsclient.samlapi.SAMLVOQueryClient;
import xmlbeans.org.oasis.saml2.protocol.NameIDMappingResponseDocument;
import xmlbeans.org.oasis.saml2.protocol.ResponseDocument;

public class Client {
    public static final String GROUP = "/Math-VO/Staff";
    public static final String GROUP2 = "/Math-VO";
    public static final String BASE_ATTR = "favouriteNumbers";
    public static final String IDENTITY = "cn=Amy, ou=ICM, c=PL";

    public static void main(String[] args) {
        boolean doHLA = true;
        boolean doLLA = true;
        if (args.length > 0) {
            if (!args[0].equals("-h") && !args[0].equals("-l")) {
                System.out.println("You must specify mode as an argument:\n  -h   - High level API test\n  -l   - Low level API test");
                System.exit(1);
            }
            if (args[0].equals("-h")) {
                doLLA = false;
            } else {
                doHLA = false;
            }
        }
        UVOSClientProperties conf = null;
        try {
            Properties p = FilePropertiesHelper.load((String)"conf/uvosClient.conf");
            conf = new UVOSClientProperties(p);
        }
        catch (Exception e1) {
            e1.printStackTrace();
            System.exit(1);
        }
        String addr = conf.getProtocol() + "://" + conf.getServerHost() + ":" + conf.getServerPort() + conf.getServicePath();
        System.out.println("Using address: " + addr);
        if (doHLA) {
            Client.runHLATestQ(conf, addr);
            Client.runHLATestM(conf, addr);
        }
        if (doLLA) {
            Client.runLowLevelAPITest(conf, addr);
        }
    }

    static void runHLATestQ(UVOSClientProperties conf, String addr) {
        block13: {
            System.out.println("\n************************\nDoing HLA test - attribute query\n************************");
            Identity subject = new Identity(IdentityType.DN, IDENTITY);
            Group scope = new Group(GROUP);
            SAMLVOClientInterface client = null;
            try {
                URI myID = new URI("http://dummy.client.net");
                client = new SAMLVOQueryClient(addr, (IClientConfiguration)conf, myID);
                System.out.println("Querying for all " + subject + " attributes");
                List<Attribute> attrs = client.getAttributes(subject);
                for (Attribute a : attrs) {
                    System.out.println("Got attr: " + a);
                }
                System.out.println("\n\nRESPONSE WAS:\n " + client.getLastResponse().xmlText(new XmlOptions().setSavePrettyPrint()) + "\n\n");
                System.out.println("Querying for " + subject + " attributes in scope " + scope);
                attrs = client.getAttributes(subject, scope);
                for (Attribute a : attrs) {
                    System.out.println("Got attr: " + a);
                }
                System.out.println("\n\nRESPONSE WAS:\n " + client.getLastResponse().xmlText(new XmlOptions().setSavePrettyPrint()) + "\n\n");
                System.out.println("Querying for all " + subject + " attributes named " + BASE_ATTR);
                attrs = client.getAttributes(subject, BASE_ATTR);
                for (Attribute a : attrs) {
                    System.out.println("Got attr: " + a);
                }
                System.out.println("\n\nRESPONSE WAS:\n " + client.getLastResponse().xmlText(new XmlOptions().setSavePrettyPrint()) + "\n\n");
                System.out.println("Querying for " + subject + " attribute named " + BASE_ATTR + " in scope of group " + scope);
                Attribute retAttr = client.getAttribute(subject, scope, BASE_ATTR);
                if (retAttr != null) {
                    System.out.println("Got attr: " + retAttr);
                }
                System.out.println("\n\nRESPONSE WAS:\n " + client.getLastResponse().xmlText(new XmlOptions().setSavePrettyPrint()) + "\n\n");
                System.out.println("Querying for " + subject + " attribute named " + BASE_ATTR + " in scope /");
                retAttr = client.getAttribute(subject, new Group("/"), BASE_ATTR);
                if (retAttr != null) {
                    System.out.println("Got attr: " + retAttr);
                }
                System.out.println("\n\nRESPONSE WAS:\n " + client.getLastResponse().xmlText(new XmlOptions().setSavePrettyPrint()) + "\n\n");
                Attribute requested = new Attribute(BASE_ATTR, null, null);
                requested.addValue("1980");
                requested.addValue("11");
                requested.addValue("444444");
                System.out.println("Querying for " + subject + " attribute " + requested + " in scope of group " + scope);
                retAttr = client.getAttribute(subject, scope, requested);
                if (retAttr != null) {
                    System.out.println("Got attr: " + retAttr);
                }
                System.out.println("\n\nRESPONSE WAS:\n " + client.getLastResponse().xmlText(new XmlOptions().setSavePrettyPrint()) + "\n\n");
                System.out.println("Querying for " + subject + " attributes " + requested + " in all scopes");
                attrs = client.getAttributes(subject, requested);
                for (Attribute a : attrs) {
                    System.out.println("Got attr: " + a);
                }
                System.out.println("\n\nRESPONSE WAS:\n " + client.getLastResponse().xmlText(new XmlOptions().setSavePrettyPrint()) + "\n\n");
                requested = new Attribute(AttributeType.DEF_AUTHZ_AT.getName(), null, null);
                System.out.println("Querying for " + subject + " attribute " + requested + " in scope of group " + scope);
                retAttr = client.getAttribute(subject, scope, requested);
                if (retAttr != null) {
                    System.out.println("Got attr: " + retAttr);
                }
                System.out.println("\n\nRESPONSE WAS:\n " + client.getLastResponse().xmlText(new XmlOptions().setSavePrettyPrint()) + "\n\n");
                requested = new Attribute(BASE_ATTR, null, null);
                requested.addValue("1980@/Math-VO/Staff");
                requested.addValue("11@/Math-VO");
                requested.addValue("444444@/Math-VO/Staff");
                System.out.println("Querying for " + subject + " attribute " + requested + " in simple mode.");
                attrs = client.getSimpleScopedAttribute(subject, requested);
                for (Attribute a : attrs) {
                    System.out.println("Got attr: " + a);
                }
                System.out.println("\n\nRESPONSE WAS:\n " + client.getLastResponse().xmlText(new XmlOptions().setSavePrettyPrint()) + "\n\n");
                requested = new Attribute(BASE_ATTR, null, null);
                requested.addValue("@/Math-VO/Staff/Admins");
                requested.addValue("900@/");
                System.out.println("Querying for " + subject + " attribute " + requested + " in simple mode.");
                attrs = client.getSimpleScopedAttribute(subject, requested);
                for (Attribute a : attrs) {
                    System.out.println("Got attr: " + a);
                }
                System.out.println("\n\nRESPONSE WAS:\n " + client.getLastResponse().xmlText(new XmlOptions().setSavePrettyPrint()) + "\n\n");
                requested = new Attribute(BASE_ATTR, null, null);
                requested.addValue("@/");
                System.out.println("Querying for " + subject + " attribute " + requested + " in simple mode.");
                attrs = client.getSimpleScopedAttribute(subject, requested);
                for (Attribute a : attrs) {
                    System.out.println("Got attr: " + a);
                }
                System.out.println("\n\nRESPONSE WAS:\n " + client.getLastResponse().xmlText(new XmlOptions().setSavePrettyPrint()) + "\n\n");
            }
            catch (Exception e) {
                e.printStackTrace();
                if (client == null || client.getLastResponse() == null) break block13;
                System.out.println("\nRESPONSE WAS: " + client.getLastResponse().xmlText(new XmlOptions().setSavePrettyPrint()));
            }
        }
    }

    static void runHLATestM(UVOSClientProperties conf, String addr) {
        block3: {
            System.out.println("\n************************\nDoing HLA test - mapping\n************************");
            Identity subject = new Identity(IdentityType.DN, IDENTITY);
            SAMLVOMapClient mapClient = null;
            try {
                mapClient = new SAMLVOMapClient(addr, (IClientConfiguration)conf);
                System.out.println("Querying for all mappings of " + subject);
                List<Identity> ids = mapClient.mapIdentity(subject);
                for (Identity id : ids) {
                    System.out.println("Got equiv id: " + id);
                }
                System.out.println("\n\nRESPONSE WAS:\n " + mapClient.getLastResponse().xmlText(new XmlOptions().setSavePrettyPrint()) + "\n\n");
                System.out.println("Querying for mappings of " + subject + " onto EMAIL");
                Identity id = mapClient.mapIdentity(subject, IdentityType.EMAIL);
                System.out.println("Got SINGLE equiv id: " + id);
                System.out.println("\n\nRESPONSE WAS:\n " + mapClient.getLastResponse().xmlText(new XmlOptions().setSavePrettyPrint()) + "\n\n");
            }
            catch (Exception e) {
                e.printStackTrace();
                if (mapClient == null || mapClient.getLastResponse() == null) break block3;
                System.out.println("\nRESPONSE WAS: " + mapClient.getLastResponse().xmlText(new XmlOptions().setSavePrettyPrint()));
            }
        }
    }

    static void runLowLevelAPITest(UVOSClientProperties conf, String addr) {
        System.out.println("\n************************\nDoing LLA test\n************************");
        UVOSClientFactory fact = new UVOSClientFactory((IClientConfiguration)conf);
        try {
            SAMLQueryInterface queryProxy = fact.getSAMLQueryClient(addr);
            Client.runQuery(queryProxy);
            SAMLNameIdMappingInterface mappingProxy = fact.getSAMLIdMappingClient(addr);
            Client.runMapping(mappingProxy);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void runQuery(SAMLQueryInterface samlProxy) throws Exception {
        AttributeQuery attrQuery = new AttributeQuery(new NameID("me@b", IdentityType.EMAIL.getName().toString()), new Subject(IDENTITY, IdentityType.DN.getName().toString()));
        System.out.println("SENDING REQUEST:\n" + attrQuery.getDoc().xmlText(new XmlOptions().setSavePrettyPrint()));
        ResponseDocument respDoc = samlProxy.attributeQuery(attrQuery.getDoc());
        System.out.println("GOT RESPONSE:\n" + respDoc.xmlText(new XmlOptions().setSavePrettyPrint()));
        attrQuery = new AttributeQuery(new NameID("me@b", IdentityType.EMAIL.getName().toString()), new Subject(IDENTITY, IdentityType.DN.getName().toString()));
        SAMLAttribute a1 = new SAMLAttribute(BASE_ATTR, "urn:oasis:names:tc:SAML:2.0:attrname-format:uri");
        SAMLAttribute a2 = new SAMLAttribute("urn:unicore:attrType:user:proffession", "urn:oasis:names:tc:SAML:2.0:attrname-format:uri");
        a2.addStringAttributeValue("staff");
        a2.addStringAttributeValue("lackof");
        attrQuery.setAttributes(new SAMLAttribute[]{a1, a2});
        System.out.println("\n\nSENDING REQUEST:\n" + attrQuery.getDoc().xmlText(new XmlOptions().setSavePrettyPrint()));
        respDoc = samlProxy.attributeQuery(attrQuery.getDoc());
        System.out.println("GOT RESPONSE:\n" + respDoc.xmlText(new XmlOptions().setSavePrettyPrint()));
        attrQuery = new AttributeQuery(new NameID("me@b", IdentityType.EMAIL.getName().toString()), new Subject(IDENTITY, IdentityType.DN.getName().toString()));
        a1 = new SAMLAttribute(BASE_ATTR, "urn:oasis:names:tc:SAML:2.0:attrname-format:uri");
        a1.setScopingType("urn:SAML:voprofile:NonScopedValue");
        attrQuery.setAttributes(new SAMLAttribute[]{a1});
        System.out.println("\n\nSENDING REQUEST:\n" + attrQuery.getDoc().xmlText(new XmlOptions().setSavePrettyPrint()));
        respDoc = samlProxy.attributeQuery(attrQuery.getDoc());
        System.out.println("GOT RESPONSE:\n" + respDoc.xmlText(new XmlOptions().setSavePrettyPrint()));
    }

    private static void runMapping(SAMLNameIdMappingInterface samlProxy) throws Exception {
        NameIDMappingRequest req = new NameIDMappingRequest(new NameID("me@b", IdentityType.EMAIL.getName().toString()), new NameID(IDENTITY, IdentityType.DN.toString()), new NameIDPolicy(IdentityType.EMAIL.toString()));
        System.out.println("\n\nSENDING REQUEST:\n" + req.getDoc().xmlText(new XmlOptions().setSavePrettyPrint()));
        NameIDMappingResponseDocument respDoc = samlProxy.mapNameId(req.getDoc());
        System.out.println("GOT RESPONSE:\n" + respDoc.xmlText(new XmlOptions().setSavePrettyPrint()));
    }
}

