/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unicore.uvos.clc;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import pl.edu.icm.unicore.uvos.api.exceptions.UVOSException;
import pl.edu.icm.unicore.uvos.clc.AbstractAction;
import pl.edu.icm.unicore.uvos.clc.ConnectionManager;

class SetTimeAction
extends AbstractAction {
    SetTimeAction(ConnectionManager cm) {
        super(cm, "setTime", "Set time in the past for the subsequent queries. After setting the time all *query* operations will query the past, historical contents of the service.\nUseful only in interactive mode\nSyntax:\n  setTime [yyyy-mm-dd hh:mm:ss]\nWithout the arguments it will return to normal operation on current contents. Example:\n  setTime 2007-01-01 23:56:00", 0);
    }

    @Override
    public boolean invoke(String[] args) throws UVOSException {
        if (args.length < 3) {
            System.out.println("Queries will be performed for current data.");
            this.cm.qTime = null;
            return true;
        }
        Date time = null;
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        try {
            time = format.parse(args[1] + "T" + args[2]);
        }
        catch (ParseException e) {
            System.out.println("Can't parse date and time: " + e.getMessage());
            return true;
        }
        this.cm.qTime = time;
        System.out.println("Queries will be performed for data at the time: " + time);
        return true;
    }
}

