/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unicore.uvos.clc;

import pl.edu.icm.unicore.uvos.api.Attribute;
import pl.edu.icm.unicore.uvos.api.Group;
import pl.edu.icm.unicore.uvos.api.PermissionDesignator;
import pl.edu.icm.unicore.uvos.api.exceptions.UVOSException;
import pl.edu.icm.unicore.uvos.clc.AbstractAction;
import pl.edu.icm.unicore.uvos.clc.ConnectionManager;

class RemoveAuthZAction
extends AbstractAction {
    RemoveAuthZAction(ConnectionManager cm) {
        super(cm, "removeAuthz", "Removes authorization policy for VO service access\nSyntax:\n   removeAuthz <group> a <AttributeName>\n   removeAuthz <group> <o|m>\nUse group '/' to modify global policy. Permissions can removed either from the bearer of an attribute or from the accessed resource owner ('o' case) or from the group members ('m' case')\nExample:\n  removeAuthz /some/group m", 2);
    }

    @Override
    public boolean invoke(String[] args) throws UVOSException {
        PermissionDesignator designator;
        Group g = null;
        if (!args[1].equals("/")) {
            g = new Group(args[1]);
        }
        if (args[2].equals("a")) {
            Attribute a = this.getAttribute(args[3], args, 4, 4);
            designator = new PermissionDesignator(a);
        } else if (args[2].equals("o")) {
            designator = new PermissionDesignator(PermissionDesignator.SpecialDesignator.OWNER);
        } else if (args[2].equals("m")) {
            designator = new PermissionDesignator(PermissionDesignator.SpecialDesignator.MEMBER);
        } else {
            System.out.println("Wrong type specified (must be 'a', 'm' or 'o')");
            return true;
        }
        this.cm.voAuthz.modifyPermissions(g, designator, null);
        return true;
    }
}

