/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unicore.uvos.clc;

import pl.edu.icm.unicore.uvos.api.Element;
import pl.edu.icm.unicore.uvos.api.exceptions.UVOSException;
import pl.edu.icm.unicore.uvos.clc.AbstractAction;
import pl.edu.icm.unicore.uvos.clc.ConnectionManager;

class RemoveAttributeAction
extends AbstractAction {
    RemoveAttributeAction(ConnectionManager cm) {
        super(cm, "removeAttribute", "Removes an attribute. Syntax:\n  removeAttribute <global> <dn|x509|email> <identity> <AttributeName>\n  removeAttribute <group> <groupPath> <AttributeName>\n  removeAttribute <ig> <dn|x509|email> <identity> <groupPath><AttributeName>\nThe first argument specifies what kind of attribute will be removed: group attribute, identity global attribute, or identity attribute valid only in particular group.\nExample:\n  removeAttribute ig email ann@example.com /group urn:unicore:attrType:user:proffession\n", 3);
    }

    @Override
    public boolean invoke(String[] args) throws UVOSException {
        Element e = this.getElement(args, 1, args.length);
        if (e == null) {
            return true;
        }
        int next = 3;
        if (e.getIdentity() != null) {
            ++next;
            if (e.getGroup() != null) {
                ++next;
            }
        }
        if (next >= args.length) {
            System.out.println("Not enough arguments.");
            return true;
        }
        this.cm.voMan.removeAttribute(e, args[next]);
        System.out.println("Removed attribute " + args[next] + " of element " + e);
        return true;
    }
}

