/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unicore.uvos.clc;

import java.util.List;
import pl.edu.icm.unicore.uvos.api.Identity;
import pl.edu.icm.unicore.uvos.api.exceptions.UVOSException;
import pl.edu.icm.unicore.uvos.clc.AbstractAction;
import pl.edu.icm.unicore.uvos.clc.ConnectionManager;

class GetAllEquivalentsAction
extends AbstractAction {
    GetAllEquivalentsAction(ConnectionManager cm) {
        super(cm, "getAllEquivalents", "Retrieves a list of all identities that are equivalent to the given one.\nSyntax:\n   getAllEquivalents <dn|x509|email> <identity1>\nExample:\n   getAllEquivalents email ann@example.com\n", 2);
    }

    @Override
    public boolean invoke(String[] args) throws UVOSException {
        Identity i = this.getIdentity(args[1], args[2], null);
        if (i == null) {
            return true;
        }
        List<Identity> equivs = this.cm.qTime == null ? this.cm.voQuery.getAllEquivalents(i) : this.cm.voQueryHistory.getAllEquivalents(i, this.cm.qTime);
        System.out.println("The following identities are equivalent:");
        for (Identity id : equivs) {
            System.out.println("  " + id);
        }
        return true;
    }
}

