/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unicore.uvos.clc;

import java.util.List;
import pl.edu.icm.unicore.uvos.api.Attribute;
import pl.edu.icm.unicore.uvos.api.Element;
import pl.edu.icm.unicore.uvos.api.exceptions.UVOSException;
import pl.edu.icm.unicore.uvos.clc.AbstractAction;
import pl.edu.icm.unicore.uvos.clc.ConnectionManager;

class GetAllAttributesAction
extends AbstractAction {
    GetAllAttributesAction(ConnectionManager cm) {
        super(cm, "getAttributes", "Returns all attributes of the given element.\nSyntax:\n   getAttributes <global> <dn|x509|email> <identity> [allScopes] [includeImpliedGroups]\n   getAttributes <group> <groupPath>\n   getAttributes <ig> <dn|x509|email> <identity> <groupPath>\nThe first argument specifies what kind of attribute will be listed: group attribute, identity global attribute, or identity attribute valid only in particular group.\nExample:\n  getAttributes ig email ann@example.com /group\n", 2);
    }

    @Override
    public boolean invoke(String[] args) throws UVOSException {
        Element e = this.getElement(args, 1, args.length);
        if (e == null) {
            return true;
        }
        int next = 3;
        if (e.getIdentity() != null) {
            ++next;
            if (e.getGroup() != null) {
                ++next;
            }
        }
        boolean scopes = false;
        boolean implied = false;
        if (next < args.length) {
            scopes = Boolean.parseBoolean(args[next++]);
        }
        if (next < args.length) {
            implied = Boolean.parseBoolean(args[next++]);
        }
        System.out.println("Effective attributes are:\n");
        List<Attribute> list = this.cm.qTime == null ? this.cm.voQuery.getAttributes(e, null, true, scopes, implied) : this.cm.voQueryHistory.getAttributes(e, null, true, scopes, implied, this.cm.qTime);
        for (Attribute a : list) {
            System.out.println("  " + a);
        }
        System.out.println("Exact attributes are:\n");
        List<Attribute> list2 = this.cm.qTime == null ? this.cm.voQuery.getAttributes(e, null, false, scopes, implied) : this.cm.voQueryHistory.getAttributes(e, null, false, scopes, implied, this.cm.qTime);
        for (Attribute a : list2) {
            System.out.println("  " + a);
        }
        return true;
    }
}

