/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unicore.uvos.clc;

import pl.edu.icm.unicore.uvos.api.Group;
import pl.edu.icm.unicore.uvos.api.exceptions.UVOSException;
import pl.edu.icm.unicore.uvos.clc.AbstractAction;
import pl.edu.icm.unicore.uvos.clc.ConnectionManager;

class CopyGroupAction
extends AbstractAction {
    CopyGroupAction(ConnectionManager cm) {
        super(cm, "copyGroup", "Copies or moves a group to a different parent group. Syntax:\n  copyGroup <grouptoBeCopiedPath> <newParentGroupPath> <doMove> [newName]\nExample:\n  copyGroup /group/subgroup /parent true movedG\nwill create group /parent/movedG with the same contents as /group/subgoup has, then /group/subgroup will be deleted.", 3);
    }

    @Override
    public boolean invoke(String[] args) throws UVOSException {
        Group g = new Group(args[1]);
        Group g2 = new Group(args[2]);
        boolean move = Boolean.parseBoolean(args[3]);
        String newName = null;
        if (args.length > 4) {
            newName = args[4];
        }
        this.cm.voMan.copyGroup(g, g2, newName, move);
        System.out.println((move ? "Moved" : "Copied") + " group: " + g + " to: " + g2);
        return true;
    }
}

