/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unicore.uvos.clc;

import pl.edu.icm.unicore.uvos.api.Group;
import pl.edu.icm.unicore.uvos.api.Identity;
import pl.edu.icm.unicore.uvos.api.exceptions.UVOSException;
import pl.edu.icm.unicore.uvos.clc.AbstractAction;
import pl.edu.icm.unicore.uvos.clc.ConnectionManager;

class AddToGroupAction
extends AbstractAction {
    AddToGroupAction(ConnectionManager cm) {
        super(cm, "addToGroup", "Adds an identity to a group. Syntax:\n  addToGroup <dn|x509|email> <identity> <groupPath>\nThe first argument is an identity type. Next is value, which is a simple string in case of 'dn' or 'email' types and a file name with X509 certificate in case of 'x509' type. It is the value of added identity. The last argument is the group path.\nExample:\n  addToGroup email john@example.com /group/subgroup\n", 3);
    }

    @Override
    public boolean invoke(String[] args) throws UVOSException {
        Identity id = this.getIdentity(args[1], args[2], args.length == 3 ? args[3] : null);
        if (id == null) {
            return true;
        }
        Group g = new Group(args[3]);
        this.cm.voMan.addToGroup(id, g);
        System.out.println("Added identity: " + id + " to group: " + g);
        return true;
    }
}

