/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl;

import com.hazelcast.cluster.ClusterImpl;
import com.hazelcast.core.ITopic;
import com.hazelcast.core.Member;
import com.hazelcast.core.MessageListener;
import com.hazelcast.core.MultiMap;
import com.hazelcast.impl.FallThroughRunnable;
import com.hazelcast.impl.MemberStateImpl;
import com.hazelcast.impl.Node;
import com.hazelcast.monitor.ClusterStateViewImpl;
import com.hazelcast.partition.Partition;
import com.hazelcast.partition.PartitionService;
import java.util.ArrayList;
import java.util.Set;

public class MemberStatePublisher
implements MessageListener {
    private final MultiMap multimap;
    private final Node node;
    public static final String STATS_TOPIC_NAME = "_hz__MemberStateTopic";
    public static final String STATS_MULTIMAP_NAME = "_hz__MemberStateMultiMap";

    public MemberStatePublisher(ITopic topic, MultiMap multimap, Node node) {
        this.multimap = multimap;
        this.node = node;
        topic.addMessageListener(this);
    }

    public void onMessage(final Object key) {
        this.node.executorManager.executeLocally(new FallThroughRunnable(){

            public void doRun() {
                if (MemberStatePublisher.this.node.joined() && MemberStatePublisher.this.node.isActive()) {
                    ClusterImpl clusterImpl = MemberStatePublisher.this.node.getClusterImpl();
                    if (MemberStatePublisher.this.node.isMaster()) {
                        ClusterStateViewImpl clusterStateView = new ClusterStateViewImpl(((MemberStatePublisher)MemberStatePublisher.this).node.factory.getLongInstanceNames());
                        PartitionService partitionService = ((MemberStatePublisher)MemberStatePublisher.this).node.factory.getPartitionService();
                        Set<Member> members = clusterImpl.getMembers();
                        for (Member member : members) {
                            clusterStateView.setPartition(member, MemberStatePublisher.this.getPartitions(partitionService, member));
                        }
                        MemberStatePublisher.this.multimap.put(key, clusterStateView);
                    }
                    MemberStateImpl memberState = ((MemberStatePublisher)MemberStatePublisher.this).node.factory.createMemberState();
                    MemberStatePublisher.this.multimap.put(key, memberState);
                }
            }
        });
    }

    private int[] getPartitions(PartitionService partitionService, Member member) {
        Set<Partition> partitions = partitionService.getPartitions();
        ArrayList<Integer> ownedPartitions = new ArrayList<Integer>();
        for (Partition partition : partitions) {
            if (!member.equals(partition.getOwner())) continue;
            ownedPartitions.add(partition.getPartitionId());
        }
        int[] ownedPartitionIds = new int[ownedPartitions.size()];
        int c = 0;
        for (Integer ownedPartition : ownedPartitions) {
            ownedPartitionIds[c++] = ownedPartition;
        }
        return ownedPartitionIds;
    }
}

