/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unicore.uvos.idhelpers;

import java.util.ArrayList;
import java.util.List;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import pl.edu.icm.unicore.uvos.api.Attribute;
import pl.edu.icm.unicore.uvos.api.AttributeType;
import pl.edu.icm.unicore.uvos.api.Identity;
import pl.edu.icm.unicore.uvos.api.exceptions.AuthenticationException;
import pl.edu.icm.unicore.uvos.api.exceptions.InvalidValueException;

public abstract class IdentityTypeHelper {
    protected Identity identity;
    protected boolean authnEncode;

    public IdentityTypeHelper(Identity identity) throws InvalidValueException {
        this.identity = identity;
        this.authnEncode = true;
    }

    public abstract String getComparableValue();

    public abstract String generateUniqueLabel();

    public abstract String generateAuthNToken() throws AuthenticationException;

    public void setAuthNTokenEncode(boolean how) {
        this.authnEncode = how;
    }

    public boolean getAuthNTokenEncode() {
        return this.authnEncode;
    }

    public abstract void validateAuthNToken(String var1) throws AuthenticationException;

    public abstract String toPrettyString();

    public abstract String toPrettyStringNoPrefix();

    public abstract List<Attribute> generateAttributes();

    protected List<Attribute> generateAttributesFromDN(String dn) throws InvalidNameException {
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        List<Rdn> rdns = new LdapName(dn).getRdns();
        for (Rdn rdn : rdns) {
            AttributeType type = new AttributeType(rdn.getType().toLowerCase());
            if (type.getName() == "emailaddress") {
                type.setName("mail");
            }
            ArrayList<String> value = new ArrayList<String>();
            value.add((String)rdn.getValue());
            attributes.add(new Attribute(type, value, null));
        }
        return attributes;
    }
}

