/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unicore.uvos.api;

import java.util.Date;
import pl.edu.icm.unicore.uvos.api.IdentityType;
import pl.edu.icm.unicore.uvos.api.PersistentObject;
import pl.edu.icm.unicore.uvos.api.exceptions.InvalidValueException;
import pl.edu.icm.unicore.uvos.idhelpers.IdentityHelperFactory;
import pl.edu.icm.unicore.uvos.idhelpers.IdentityTypeHelper;

public class Identity
extends PersistentObject {
    private static final long serialVersionUID = -1610378565403226478L;
    private IdentityType type;
    private String value;
    private String label;
    private String persistentEntityId;
    private Object authnData;
    private boolean inactive;
    private transient IdentityTypeHelper idH = null;

    public Identity(IdentityType type, String value, String label, String persistentId, Date creationTS, Date removalTS) {
        super(creationTS, removalTS);
        this.type = type;
        this.value = value;
        this.label = label;
        this.persistentEntityId = persistentId;
        this.inactive = false;
    }

    public Identity(IdentityType type, String value, String label, Date creationTS, Date removalTS) {
        this(type, value, label, null, creationTS, removalTS);
    }

    public Identity(IdentityType type, String value, String label) {
        this(type, value, label, null, null);
    }

    public Identity(IdentityType type, String value) {
        this(type, value, null, null, null);
    }

    public IdentityType getType() {
        return this.type;
    }

    public void setType(IdentityType type) {
        this.type = type;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String toString() {
        StringBuffer ret = new StringBuffer();
        if (this.inactive) {
            ret.append("DISABLED ");
        }
        if (this.getLabel() != null) {
            ret.append("Label: ").append(this.getLabel());
            if (this.getPersistentEntityId() != null) {
                ret.append(" ");
            }
        }
        if (this.getPersistentEntityId() != null) {
            ret.append("EntId: ").append(this.getPersistentEntityId());
        }
        if (this.getLabel() != null || this.getPersistentEntityId() != null) {
            ret.append(": ");
        }
        ret.append("{");
        ret.append(this.type.toString());
        ret.append("}");
        ret.append(this.value);
        return ret.toString();
    }

    public String prettyString() {
        if (this.idH == null) {
            try {
                this.idH = IdentityHelperFactory.getHelper(this);
            }
            catch (InvalidValueException invalidValueException) {
                // empty catch block
            }
        }
        return this.idH == null ? this.toString() : this.idH.toPrettyString();
    }

    public String prettyStringNoPrefix() {
        if (this.idH == null) {
            try {
                this.idH = IdentityHelperFactory.getHelper(this);
            }
            catch (InvalidValueException invalidValueException) {
                // empty catch block
            }
        }
        return this.idH == null ? this.toString() : this.idH.toPrettyStringNoPrefix();
    }

    public Object getAuthnData() {
        return this.authnData;
    }

    public void setAuthnData(Object authnData) {
        this.authnData = authnData;
    }

    public boolean equals(Object cmpO) {
        if (!(cmpO instanceof Identity)) {
            return false;
        }
        Identity cmp = (Identity)cmpO;
        if (!cmp.getType().equals(this.getType())) {
            return false;
        }
        try {
            IdentityTypeHelper helper = IdentityHelperFactory.getHelper(this);
            String a = helper.getComparableValue();
            IdentityTypeHelper helper2 = IdentityHelperFactory.getHelper(cmp);
            String b = helper2.getComparableValue();
            if (!a.equals(b)) {
                return false;
            }
        }
        catch (InvalidValueException e) {
            return false;
        }
        return true;
    }

    public String getPersistentEntityId() {
        return this.persistentEntityId;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        try {
            IdentityTypeHelper helper = IdentityHelperFactory.getHelper(this);
            String a = helper.getComparableValue();
            result = 31 * result + a.hashCode();
        }
        catch (InvalidValueException e) {
            result = 31 * result;
        }
        return result;
    }

    public void setPersistentEntityId(String persistentEntityId) {
        this.persistentEntityId = persistentEntityId;
    }

    public boolean isInactive() {
        return this.inactive;
    }

    public void setInactive(boolean inactive) {
        this.inactive = inactive;
    }
}

