/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unicore.uvos.api;

import java.util.Arrays;
import java.util.Date;
import pl.edu.icm.unicore.uvos.api.PersistentObject;

public class Group
extends PersistentObject {
    private static final long serialVersionUID = 3998046003576679859L;
    private String[] path;

    public Group(String[] parent, String name, Date creationTS, Date removalTS) {
        super(creationTS, removalTS);
        this.path = new String[parent.length + 1];
        for (int i = 0; i < parent.length; ++i) {
            this.path[i] = parent[i];
        }
        this.path[this.path.length - 1] = name;
    }

    public Group(String[] parent, String name) {
        this(parent, name, null, null);
    }

    public Group(String[] path, Date creationTS, Date removalTS) {
        super(creationTS, removalTS);
        this.path = path;
    }

    public Group(String[] path) {
        super(null, null);
        this.path = path;
    }

    public Group(String path) {
        super(null, null);
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        this.path = path.split("/");
        if (this.path.length == 1 && this.path[0].equals("")) {
            this.path = new String[0];
        }
    }

    public boolean isChild(Group test) {
        String[] tPath = test.getPath();
        if (tPath.length > this.path.length) {
            return false;
        }
        for (int i = 0; i < tPath.length; ++i) {
            if (tPath[i].equals(this.path[i])) continue;
            return false;
        }
        return true;
    }

    public boolean isTopLevel() {
        return this.path.length == 0;
    }

    public String[] getPath() {
        return this.path;
    }

    public void setPath(String[] path) {
        this.path = path;
    }

    public void setName(String newName) {
        this.path[this.path.length - 1] = newName;
    }

    public String getName() {
        return this.path[this.path.length - 1];
    }

    public Group getParent() {
        if (this.path.length < 2) {
            return null;
        }
        String[] newPath = new String[this.path.length - 1];
        for (int i = 0; i < newPath.length; ++i) {
            newPath[i] = this.path[i];
        }
        return new Group(newPath);
    }

    public String toString() {
        if (this.path.length == 0) {
            return "/";
        }
        StringBuilder ret = new StringBuilder(this.path.length * 2);
        for (int i = 0; i < this.path.length; ++i) {
            ret.append("/").append(this.path[i]);
        }
        return ret.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.path);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Group other = (Group)obj;
        return Arrays.equals(this.path, other.path);
    }
}

