/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.wsrflite.xmlbeans.wsn.impl;

import de.fzj.unicore.wsrflite.Home;
import de.fzj.unicore.wsrflite.Kernel;
import de.fzj.unicore.wsrflite.exceptions.ResourceUnknownException;
import de.fzj.unicore.wsrflite.messaging.Message;
import de.fzj.unicore.wsrflite.messaging.MessagingException;
import de.fzj.unicore.wsrflite.messaging.PullPoint;
import de.fzj.unicore.wsrflite.utils.WSServerUtilities;
import de.fzj.unicore.wsrflite.xmlbeans.BaseFault;
import de.fzj.unicore.wsrflite.xmlbeans.WSUtilities;
import de.fzj.unicore.wsrflite.xmlbeans.wsn.Event;
import de.fzj.unicore.wsrflite.xmlbeans.wsn.EventPoster;
import de.fzj.unicore.wsrflite.xmlbeans.wsn.IServerSubscription;
import de.fzj.unicore.wsrflite.xmlbeans.wsn.NotificationProducer;
import de.fzj.unicore.wsrflite.xmlbeans.wsn.Topic;
import de.fzj.unicore.wsrflite.xmlbeans.wsn.WSNMessage;
import de.fzj.unicore.wsrflite.xmlbeans.wsn.impl.SubscriptionImpl;
import de.fzj.unicore.wsrflite.xmlbeans.wsn.util.ConcreteWSNTopicExpression;
import de.fzj.unicore.wsrflite.xmlbeans.wsn.util.SimpleWSNTopicExpression;
import eu.unicore.util.Log;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.XmlObject;
import org.oasisOpen.docs.wsn.b2.ConsumerReferenceDocument;
import org.oasisOpen.docs.wsn.b2.CreationTimeDocument;
import org.oasisOpen.docs.wsn.b2.FilterDocument;
import org.oasisOpen.docs.wsn.b2.FilterType;
import org.oasisOpen.docs.wsn.b2.FixedTopicSetDocument;
import org.oasisOpen.docs.wsn.b2.GetCurrentMessageDocument;
import org.oasisOpen.docs.wsn.b2.GetCurrentMessageResponseDocument;
import org.oasisOpen.docs.wsn.b2.NotificationMessageHolderType;
import org.oasisOpen.docs.wsn.b2.NotifyDocument;
import org.oasisOpen.docs.wsn.b2.SubscribeDocument;
import org.oasisOpen.docs.wsn.b2.SubscribeResponseDocument;
import org.oasisOpen.docs.wsn.b2.TopicDocument;
import org.oasisOpen.docs.wsn.b2.TopicExpressionDialectDocument;
import org.oasisOpen.docs.wsn.b2.TopicExpressionDocument;
import org.oasisOpen.docs.wsn.b2.TopicExpressionType;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

public class NotificationProducerSupport
implements NotificationProducer,
Serializable,
EventPoster {
    protected static final Logger logger = Log.getLogger((String)"unicore.wsrflite", NotificationProducerSupport.class);
    private static final long serialVersionUID = 1611171807261355827L;
    protected ArrayList<TopicDocument> topics = new ArrayList();
    protected ArrayList<String> subscriptionIds = new ArrayList();
    private ArrayList<Event> events = new ArrayList();
    private String producerURL;
    private String subscriptionServiceName = "Subscription";
    private volatile Kernel kernel;

    public NotificationProducerSupport(Kernel k) {
        this.kernel = k;
    }

    public void setKernel(Kernel k) {
        this.kernel = k;
    }

    public GetCurrentMessageResponseDocument GetCurrentMessage(GetCurrentMessageDocument req) throws BaseFault {
        GetCurrentMessageResponseDocument res = GetCurrentMessageResponseDocument.Factory.newInstance();
        res.addNewGetCurrentMessageResponse();
        return res;
    }

    public String getProducerURL() {
        return this.producerURL;
    }

    public void setProducerURL(String url) {
        this.producerURL = url;
    }

    public SubscribeResponseDocument Subscribe(SubscribeDocument req) throws BaseFault {
        try {
            ConsumerReferenceDocument ref = ConsumerReferenceDocument.Factory.newInstance();
            ref.setConsumerReference(req.getSubscribe().getConsumerReference());
            FilterType f = req.getSubscribe().getFilter();
            if (!this.acceptTopic(f)) {
                throw BaseFault.createFault((String)"Topic not supported.");
            }
            Home h = this.kernel.getHome(this.subscriptionServiceName);
            if (h == null) {
                throw new BaseFault("Subscription not possible. Server is not configured for subscriptions, since service <" + this.subscriptionServiceName + "> is not enabled.");
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put(SubscriptionImpl.ConsumerRefKey, ref);
            FilterDocument fdoc = FilterDocument.Factory.newInstance();
            fdoc.setFilter(f);
            map.put(SubscriptionImpl.FilterKey, fdoc);
            CreationTimeDocument ctd = CreationTimeDocument.Factory.newInstance();
            ctd.setCreationTime(Calendar.getInstance());
            map.put(SubscriptionImpl.CreationTimeKey, ctd);
            map.put(SubscriptionImpl.NotificationProducerRefKey, this.getProducerURL());
            String id = h.createWSRFServiceInstance(map);
            this.subscriptionIds.add(id);
            EndpointReferenceType epr = EndpointReferenceType.Factory.newInstance();
            String address = WSServerUtilities.makeAddress(this.subscriptionServiceName, id, this.kernel.getContainerProperties());
            epr.addNewAddress().setStringValue(address);
            SubscribeResponseDocument res = SubscribeResponseDocument.Factory.newInstance();
            res.addNewSubscribeResponse().setSubscriptionReference(epr);
            return res;
        }
        catch (BaseFault bf) {
            throw bf;
        }
        catch (Exception e) {
            Log.logException((String)"Error processing subscription request.", (Throwable)e, (Logger)logger);
            throw BaseFault.createFault((String)e.getMessage(), (Throwable)e);
        }
    }

    public boolean deleteSubscription(String subscriptionID) {
        return this.subscriptionIds.remove(subscriptionID);
    }

    protected boolean acceptTopic(FilterType f) {
        return true;
    }

    public void postEvent(QName q, XmlObject[] newValue) {
        Event event = new Event(q, newValue);
        this.events.add(event);
    }

    public void postEvent(Event event) {
        this.events.add(event);
    }

    public FixedTopicSetDocument getFixedTopicSetDocument() {
        FixedTopicSetDocument doc = FixedTopicSetDocument.Factory.newInstance();
        doc.setFixedTopicSet(true);
        return doc;
    }

    public TopicExpressionDocument[] getTopicExpressionDocuments() {
        TopicExpressionDocument[] docs = new TopicExpressionDocument[this.topics.size()];
        for (int i = 0; i < this.topics.size(); ++i) {
            docs[i] = TopicExpressionDocument.Factory.newInstance();
            docs[i].setTopicExpression(this.topics.get(i).getTopic());
        }
        return docs;
    }

    public TopicExpressionDialectDocument[] getExpressionDialectDocument() {
        ArrayList<TopicExpressionDialectDocument> result = new ArrayList<TopicExpressionDialectDocument>();
        TopicExpressionDialectDocument docSimple = TopicExpressionDialectDocument.Factory.newInstance();
        docSimple.setTopicExpressionDialect("http://docs.oasis-open.org/wsn/t-1/TopicExpression/Simple");
        result.add(docSimple);
        TopicExpressionDialectDocument docConcrete = TopicExpressionDialectDocument.Factory.newInstance();
        docConcrete.setTopicExpressionDialect("http://docs.oasis-open.org/wsn/t-1/TopicExpression/Concrete");
        result.add(docConcrete);
        return result.toArray(new TopicExpressionDialectDocument[result.size()]);
    }

    public void addSimpleTopic(QName q) {
        TopicDocument o = TopicDocument.Factory.newInstance();
        TopicExpressionType expr = new SimpleWSNTopicExpression(q).toXml().getTopicExpression();
        o.setTopic(expr);
        this.topics.add(o);
    }

    public void addConcreteTopic(Topic t) {
        TopicDocument o = TopicDocument.Factory.newInstance();
        TopicExpressionType expr = new ConcreteWSNTopicExpression(t).toXml().getTopicExpression();
        o.setTopic(expr);
        this.topics.add(o);
    }

    public void addTopic(TopicExpressionType expr) {
        if (expr == null) {
            return;
        }
        TopicDocument o = TopicDocument.Factory.newInstance();
        o.setTopic(expr);
        this.topics.add(o);
    }

    protected NotificationMessageHolderType createMessage(IServerSubscription subscription, Event e) {
        NotificationMessageHolderType m = NotificationMessageHolderType.Factory.newInstance();
        m.addNewProducerReference().addNewAddress().setStringValue(this.getProducerURL());
        m.addNewMessage();
        for (XmlObject o : e.getNewValue()) {
            WSUtilities.append((XmlObject)o, (XmlObject)m.getMessage());
        }
        try {
            TopicExpressionType topicExpr = TopicExpressionType.Factory.parse((InputStream)subscription.getTopicExpression().newInputStream());
            m.setTopic(topicExpr);
        }
        catch (Exception e1) {
            Log.logException((String)"Error creating notification messaget.", (Throwable)e1, (Logger)logger);
        }
        String address = WSServerUtilities.makeAddress(this.subscriptionServiceName, subscription.getUniqueID(), this.kernel.getContainerProperties());
        m.addNewSubscriptionReference().addNewAddress().setStringValue(address);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)m.toString());
        }
        return m;
    }

    public void sendNotifications(NotificationMessageHolderType[] messages, ConsumerReferenceDocument consumer, String filter) throws MessagingException {
        if (!this.passesMessageContentFilter(filter, messages)) {
            return;
        }
        WSNMessage msg = new WSNMessage();
        msg.setBody((Serializable)messages);
        msg.setTo((EndpointReferenceType)consumer.getConsumerReference().copy());
        this.kernel.getMessaging().getChannel("CHANNEL:http://docs.oasis-open.org/wsn/bw-2").publish((Message)msg);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Message sent to " + consumer.getConsumerReference().getAddress()));
        }
    }

    protected boolean passesMessageContentFilter(String mcd, NotificationMessageHolderType[] messages) {
        if (mcd == null) {
            return true;
        }
        try {
            logger.info((Object)("Check xpath:" + mcd));
            NotifyDocument nd = NotifyDocument.Factory.newInstance();
            nd.addNewNotify().setNotificationMessageArray(messages);
            logger.info((Object)nd.toString());
            XmlObject[] os = nd.selectPath(mcd);
            return os.length > 0;
        }
        catch (Exception e) {
            Log.logException((String)("Reject sending message: " + e.getLocalizedMessage()), (Throwable)e, (Logger)logger);
            return false;
        }
    }

    protected synchronized void updateSubscriptionIds() {
        try {
            PullPoint p = this.kernel.getMessaging().getPullPoint("TODO");
            while (p.hasNext()) {
                Message m = p.next();
                String r = (String)((Object)m.getBody());
                this.subscriptionIds.remove(r);
                logger.debug((Object)("Destroy message received: removed subscription " + r));
            }
        }
        catch (Exception e) {
            Log.logException((String)"Error updating subscription list.", (Throwable)e, (Logger)logger);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyObservers() {
        ArrayList<Event> arrayList = this.events;
        synchronized (arrayList) {
            ArrayList<String> removedSubscriptions = new ArrayList<String>();
            try {
                Home h = this.kernel.getHome(this.subscriptionServiceName);
                for (String id : this.subscriptionIds) {
                    IServerSubscription subscription = null;
                    try {
                        subscription = (IServerSubscription)h.get(id);
                    }
                    catch (ResourceUnknownException e) {
                        removedSubscriptions.add(id);
                    }
                    for (Event e : this.events) {
                        if (subscription == null || !subscription.match(e)) continue;
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Matched event <" + e.getQName() + "> to subscription <" + id + ">"));
                        }
                        NotificationMessageHolderType msg = this.createMessage(subscription, e);
                        this.sendNotifications(new NotificationMessageHolderType[]{msg}, subscription.getConsumerReference(), subscription.getMessageContentFilter());
                    }
                }
                this.subscriptionIds.removeAll(removedSubscriptions);
                this.events.clear();
            }
            catch (Exception e) {
                Log.logException((String)"Error on notification.", (Throwable)e, (Logger)logger);
            }
        }
    }

    public void setSubscriptionServiceName(String subscriptionServiceName) {
        this.subscriptionServiceName = subscriptionServiceName;
    }
}

