/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.wsrflite.xmlbeans.wsn.impl;

import de.fzj.unicore.wsrflite.messaging.PullPoint;
import de.fzj.unicore.wsrflite.persistence.Persist;
import de.fzj.unicore.wsrflite.utils.WSServerUtilities;
import de.fzj.unicore.wsrflite.xmlbeans.BaseFault;
import de.fzj.unicore.wsrflite.xmlbeans.WSUtilities;
import de.fzj.unicore.wsrflite.xmlbeans.exceptions.ResourceUnavailableFault;
import de.fzj.unicore.wsrflite.xmlbeans.exceptions.ResourceUnknownFault;
import de.fzj.unicore.wsrflite.xmlbeans.exceptions.TerminationTimeChangeRejectedFault;
import de.fzj.unicore.wsrflite.xmlbeans.exceptions.UnableToSetTerminationTimeFault;
import de.fzj.unicore.wsrflite.xmlbeans.impl.WSResourceImpl;
import de.fzj.unicore.wsrflite.xmlbeans.rp.ImmutableResourceProperty;
import de.fzj.unicore.wsrflite.xmlbeans.wsn.WSRFNotificationProducer;
import de.fzj.unicore.wsrflite.xmlbeans.wsn.impl.NotificationProducerSupport;
import java.io.Serializable;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.xmlbeans.XmlObject;
import org.oasisOpen.docs.wsn.b2.GetCurrentMessageDocument;
import org.oasisOpen.docs.wsn.b2.GetCurrentMessageResponseDocument;
import org.oasisOpen.docs.wsn.b2.NotificationProducerRPDocument;
import org.oasisOpen.docs.wsn.b2.SubscribeDocument;
import org.oasisOpen.docs.wsn.b2.SubscribeResponseDocument;
import org.oasisOpen.docs.wsrf.rl2.SetTerminationTimeDocument;
import org.oasisOpen.docs.wsrf.rl2.SetTerminationTimeResponseDocument;
import org.oasisOpen.docs.wsrf.rp2.ResourcePropertyValueChangeNotificationDocument;
import org.oasisOpen.docs.wsrf.rp2.ResourcePropertyValueChangeNotificationType;

public abstract class NotificationProducerImpl
extends WSResourceImpl
implements WSRFNotificationProducer {
    @Persist
    protected NotificationProducerSupport npSupport;

    @Override
    public QName getResourcePropertyDocumentQName() {
        return NotificationProducerRPDocument.type.getDocumentElementName();
    }

    public GetCurrentMessageResponseDocument GetCurrentMessage(GetCurrentMessageDocument req) throws BaseFault {
        return this.npSupport.GetCurrentMessage(req);
    }

    public SubscribeResponseDocument Subscribe(SubscribeDocument req) throws BaseFault {
        return this.npSupport.Subscribe(req);
    }

    @Override
    public void initialise(String serviceName, Map<String, Object> initobjs) throws Exception {
        super.initialise(serviceName, initobjs);
        this.npSupport = new NotificationProducerSupport(this.home.getKernel());
        String address = WSServerUtilities.makeAddress(this.getServiceName(), this.getUniqueID(), this.home.getKernel().getContainerProperties());
        this.npSupport.setProducerURL(address);
        this.properties.put(RPTopicExpression, new ImmutableResourceProperty((XmlObject[])this.npSupport.getTopicExpressionDocuments()));
        this.properties.put(RPFixedTopicSet, new ImmutableResourceProperty((XmlObject)this.npSupport.getFixedTopicSetDocument()));
        this.properties.put(RPTopicExpressionDialect, new ImmutableResourceProperty((XmlObject[])this.npSupport.getExpressionDialectDocument()));
    }

    @Override
    public SetTerminationTimeResponseDocument SetTerminationTime(SetTerminationTimeDocument in) throws UnableToSetTerminationTimeFault, TerminationTimeChangeRejectedFault, ResourceUnknownFault, ResourceUnavailableFault {
        SetTerminationTimeResponseDocument res = super.SetTerminationTime(in);
        this.npSupport.postEvent(RPterminationTimeQName, this.getResourcePropertyValueChangeNotification(RPterminationTimeQName));
        return res;
    }

    protected XmlObject[] getResourcePropertyValueChangeNotification(QName rpName) {
        XmlObject[] rp = this.getResourcePropertyXML(rpName);
        ResourcePropertyValueChangeNotificationDocument rpd = ResourcePropertyValueChangeNotificationDocument.Factory.newInstance();
        rpd.addNewResourcePropertyValueChangeNotification().setNilOldValues();
        ResourcePropertyValueChangeNotificationType.NewValues nv = rpd.getResourcePropertyValueChangeNotification().addNewNewValues();
        for (XmlObject o : rp) {
            WSUtilities.insertAny((XmlObject)o, (XmlObject)nv);
        }
        return new XmlObject[]{rpd};
    }

    public Map<String, Serializable> passivate() {
        this.npSupport.notifyObservers();
        return super.passivate();
    }

    public void postActivate() {
        try {
            this.npSupport.setKernel(this.home.getKernel());
            logger.trace((Object)("Getting messages from queue " + this.getUniqueID()));
            PullPoint p = this.home.getKernel().getMessaging().getPullPoint(this.getUniqueID());
            while (p.hasNext()) {
                String m = (String)((Object)p.next().getBody());
                logger.trace((Object)("Read: " + m));
                if (!m.startsWith("deleted:")) continue;
                String id = m.substring(m.indexOf(":") + 1);
                this.npSupport.deleteSubscription(id);
                this.setDirty();
            }
        }
        catch (Exception e) {
            logger.warn((Object)e.getMessage());
        }
    }
}

