/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.wsrflite.xmlbeans.sg.impl;

import de.fzj.unicore.wsrflite.ContainerProperties;
import de.fzj.unicore.wsrflite.Home;
import de.fzj.unicore.wsrflite.Resource;
import de.fzj.unicore.wsrflite.exceptions.ResourceUnknownException;
import de.fzj.unicore.wsrflite.utils.WSServerUtilities;
import de.fzj.unicore.wsrflite.xmlbeans.BaseFault;
import de.fzj.unicore.wsrflite.xmlbeans.WSUtilities;
import de.fzj.unicore.wsrflite.xmlbeans.sg.ServiceGroupRegistration;
import de.fzj.unicore.wsrflite.xmlbeans.sg.impl.EntryResourceProperty;
import de.fzj.unicore.wsrflite.xmlbeans.sg.impl.ServiceGroupEntryImpl;
import de.fzj.unicore.wsrflite.xmlbeans.sg.impl.ServiceGroupImpl;
import eu.unicore.util.Log;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.GDateBuilder;
import org.apache.xmlbeans.GDuration;
import org.apache.xmlbeans.GDurationSpecification;
import org.apache.xmlbeans.XmlDateTime;
import org.apache.xmlbeans.XmlDuration;
import org.apache.xmlbeans.XmlObject;
import org.oasisOpen.docs.wsrf.rl2.SetTerminationTimeDocument;
import org.oasisOpen.docs.wsrf.sg2.AddDocument;
import org.oasisOpen.docs.wsrf.sg2.AddResponseDocument;
import org.oasisOpen.docs.wsrf.sg2.ContentType;
import org.oasisOpen.docs.wsrf.sg2.EntryDocument;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

public class ServiceGroupRegistrationImpl
extends ServiceGroupImpl
implements ServiceGroupRegistration {
    protected static final long serialVersionUID = 980349444L;
    protected static final Logger logger = Log.getLogger((String)"unicore.services", ServiceGroupRegistrationImpl.class);

    public AddResponseDocument Add(AddDocument in) throws BaseFault {
        AddResponseDocument res = AddResponseDocument.Factory.newInstance();
        res.addNewAddResponse();
        try {
            ContentType content;
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Add:" + in));
            }
            EndpointReferenceType epr = in.getAdd().getMemberEPR();
            EntryDocument entry = this.getEntry(epr);
            EndpointReferenceType sgeEpr = null;
            Calendar tt = this.getDefaultTerminationTime();
            try {
                Calendar requestedTT = this.makeCalendar(in.getAdd().getInitialTerminationTime());
                if (requestedTT != null) {
                    tt = requestedTT;
                    logger.debug((Object)("Termination time requested: " + tt.getTime() + ". Using this instead of default value."));
                }
            }
            catch (Exception e) {
                Log.logException((String)"Error setting initial TT to requested value.", (Throwable)e, (Logger)logger);
            }
            if (entry != null) {
                logger.info((Object)("Refreshing registry entry for: " + epr.getAddress().getStringValue()));
                try {
                    sgeEpr = entry.getEntry().getServiceGroupEntryEPR();
                    content = in.getAdd().getContent();
                    this.updateServiceGroupEntry(entry, sgeEpr, tt, content, epr);
                    res.getAddResponse().setTerminationTime(tt);
                    res.getAddResponse().setServiceGroupEntryReference(sgeEpr);
                    return res;
                }
                catch (ResourceUnknownException e) {
                    System.out.println("Resource unknown " + sgeEpr);
                    this.removeEntry(entry);
                }
                catch (Exception e) {
                    logger.warn((Object)"Can't update service group entry!", (Throwable)e);
                }
            }
            logger.info((Object)("Creating new registry entry for service: " + epr.getAddress().getStringValue()));
            content = in.getAdd().getContent();
            entry = EntryDocument.Factory.newInstance();
            entry.addNewEntry().setContent(content);
            entry.getEntry().setMemberServiceEPR(epr);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("de.fzj.unicore.wsrflite.terminationtime.initialvalue", tt);
            map.put(ServiceGroupEntryImpl.INIT_MEMBER_EPR, epr);
            map.put(ServiceGroupEntryImpl.INIT_CONTENT, content);
            EndpointReferenceType entryEpr = WSServerUtilities.makeEPR(this.getServiceName(), this.getUniqueID(), this.getKernel());
            map.put(ServiceGroupEntryImpl.INIT_SERVICEGROUP_EPR, entryEpr);
            map.put(INIT_PARENT_NODE, this.nodeHelper);
            sgeEpr = this.createServiceGroupEntry(map);
            entry.getEntry().setServiceGroupEntryEPR(sgeEpr);
            this.addEntry(entry);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("New service group entry: " + WSUtilities.extractResourceID((EndpointReferenceType)sgeEpr)));
            }
            res.getAddResponse().setTerminationTime(tt);
            res.getAddResponse().setServiceGroupEntryReference(sgeEpr);
            return res;
        }
        catch (Exception e) {
            Log.logException((String)"Error adding", (Throwable)e, (Logger)logger);
            e.printStackTrace();
            throw BaseFault.createFault((String)e.getMessage());
        }
    }

    protected void removeEntry(EntryDocument entry) {
        String entryID = WSUtilities.extractResourceID((EndpointReferenceType)entry.getEntry().getServiceGroupEntryEPR());
        EntryResourceProperty erp = (EntryResourceProperty)this.getResourceProperty(RPEntry);
        erp.deleteEntry(entryID);
    }

    protected EndpointReferenceType createServiceGroupEntry(Map<String, Object> initObjs) throws Exception {
        Home sgeHome = this.getKernel().getHome("ServiceGroupEntry");
        String uID = sgeHome.createWSRFServiceInstance(initObjs);
        EndpointReferenceType epr = EndpointReferenceType.Factory.newInstance();
        String address = WSServerUtilities.makeAddress("ServiceGroupEntry", uID, this.getKernel().getContainerProperties());
        epr.addNewAddress().setStringValue(address);
        return epr;
    }

    public Calendar makeCalendar(Object initialTT) {
        if (initialTT == null) {
            return null;
        }
        Calendar c = null;
        try {
            XmlDateTime d = XmlDateTime.Factory.newValue((Object)initialTT);
            c = d.getCalendarValue();
            return c;
        }
        catch (Exception e) {
            try {
                XmlDuration d = XmlDuration.Factory.newValue((Object)initialTT);
                GDuration duration = d.getGDurationValue();
                GDateBuilder b = new GDateBuilder();
                b.addGDuration((GDurationSpecification)duration);
                c = Calendar.getInstance();
                c.setTime(b.getDate());
                return c;
            }
            catch (Exception exception) {
                return null;
            }
        }
    }

    public EntryDocument getEntry(EndpointReferenceType epr) {
        XmlObject[] entries = this.getResourcePropertyXML(RPEntry);
        if (entries == null) {
            return null;
        }
        for (XmlObject o : entries) {
            EntryDocument entry = (EntryDocument)o;
            EndpointReferenceType member = entry.getEntry().getMemberServiceEPR();
            if (!this.equalEPRs(member, epr)) continue;
            return entry;
        }
        return null;
    }

    public boolean equalEPRs(EndpointReferenceType epr1, EndpointReferenceType epr2) {
        return epr1.getAddress().getStringValue().equalsIgnoreCase(epr2.getAddress().getStringValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateServiceGroupEntry(EntryDocument entry, EndpointReferenceType epr, Calendar tt, ContentType content, EndpointReferenceType memberEPR) throws Exception {
        logger.debug((Object)("Updating information for " + memberEPR.getAddress().getStringValue()));
        Home sgeHome = this.getKernel().getHome("ServiceGroupEntry");
        String uID = WSUtilities.extractResourceID((EndpointReferenceType)epr);
        ServiceGroupEntryImpl wsr = (ServiceGroupEntryImpl)sgeHome.getForUpdate(uID);
        try {
            SetTerminationTimeDocument stt = SetTerminationTimeDocument.Factory.newInstance();
            stt.addNewSetTerminationTime().setRequestedTerminationTime(tt);
            wsr.SetTerminationTime(stt);
            wsr.updateContent(content);
            wsr.updateMemberServiceEPR(memberEPR);
            wsr.setDirty();
            if (content != null && !content.isNil()) {
                entry.getEntry().setContent(content);
            }
            entry.getEntry().setMemberServiceEPR(memberEPR);
        }
        finally {
            if (wsr != null) {
                this.getKernel().getPersistenceManager().persist((Resource)wsr);
            }
        }
    }

    public Calendar getDefaultTerminationTime() {
        ContainerProperties cfg = this.getKernel().getContainerProperties();
        long defaultTerminationTime = cfg.getLongValue("wsrf.sg.defaulttermtime");
        Calendar tt = Calendar.getInstance();
        tt.setTimeInMillis(System.currentTimeMillis() + defaultTerminationTime * 1000L);
        return tt;
    }
}

