/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.wsrflite.xmlbeans.sg.impl;

import de.fzj.unicore.wsrflite.Resource;
import de.fzj.unicore.wsrflite.xmlbeans.ResourceProperty;
import java.util.ArrayList;
import java.util.Iterator;
import org.oasisOpen.docs.wsrf.sg2.EntryDocument;
import org.oasisOpen.docs.wsrf.sg2.EntryType;

public class EntryResourceProperty
extends ResourceProperty<EntryType[]> {
    private static final long serialVersionUID = -7863996020517761951L;
    protected ArrayList<EntryDocument> entries = new ArrayList();
    private EntryDocument[] xdoc;

    public EntryResourceProperty(Resource parent) {
        super(parent);
    }

    public void add(EntryDocument e) {
        this.entries.add(e);
        this.xdoc = this.entries.toArray(new EntryDocument[this.entries.size()]);
    }

    public void deleteEntry(EntryDocument entry) {
        this.entries.remove(entry);
        this.xdoc = this.entries.toArray(new EntryDocument[this.entries.size()]);
    }

    public void deleteEntry(String id) {
        Iterator<EntryDocument> iter = this.entries.iterator();
        while (iter.hasNext()) {
            EntryDocument ed = iter.next();
            if (!ed.getEntry().getServiceGroupEntryEPR().getAddress().getStringValue().contains(id)) continue;
            iter.remove();
        }
        this.xdoc = this.entries.toArray(new EntryDocument[this.entries.size()]);
    }

    public EntryDocument[] getXml() {
        return this.xdoc;
    }

    public EntryType[] getProperty() {
        EntryType[] ets = new EntryType[this.entries.size()];
        for (int i = 0; i < this.entries.size(); ++i) {
            ets[i] = this.entries.get(i).getEntry();
        }
        return ets;
    }

    public void setProperty(EntryType[] setTo) {
        ArrayList<EntryDocument> n = new ArrayList<EntryDocument>();
        for (EntryType e : setTo) {
            EntryDocument newEntry = EntryDocument.Factory.newInstance();
            newEntry.setEntry(e);
            n.add(newEntry);
        }
        this.entries = n;
    }
}

