/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.wsrflite.xmlbeans.registry;

import de.fzj.unicore.wsrflite.Kernel;
import de.fzj.unicore.wsrflite.utils.WSServerUtilities;
import de.fzj.unicore.wsrflite.xmlbeans.client.BaseWSRFClient;
import de.fzj.unicore.wsrflite.xmlbeans.client.ExternalRegistryClient;
import de.fzj.unicore.wsrflite.xmlbeans.client.RegistryClient;
import eu.unicore.util.Log;
import eu.unicore.util.httpclient.IClientConfiguration;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.oasisOpen.docs.wsrf.sg2.AddDocument;
import org.oasisOpen.docs.wsrf.sg2.ContentType;
import org.oasisOpen.docs.wsrf.sg2.EntryType;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

public class VORegistryHandler {
    private static final Logger logger = Log.getLogger((String)"unicore.services", VORegistryHandler.class);
    private final Set<String> externalRegistryURLs = new HashSet<String>();
    private final Map<String, AddDocument> registeredEndpoints = new HashMap<String, AddDocument>();
    private final Kernel kernel;

    public VORegistryHandler(Kernel kernel, String ... urls) {
        this.kernel = kernel;
        this.setExternalRegistryURLs(urls);
    }

    public synchronized void setExternalRegistryURLs(String ... urls) {
        for (String url : urls) {
            this.externalRegistryURLs.add(url);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMember(String eprAddress, ContentType content) throws Exception {
        ExternalRegistryClient client = this.getExternalRegistryClient();
        AddDocument in = AddDocument.Factory.newInstance();
        in.addNewAdd().setContent(content);
        in.getAdd().setMemberEPR(this.getEPR(this.kernel, eprAddress));
        if (!client.checkConnection()) {
            throw new Exception("Can't connect to the VO registry");
        }
        client.addRegistryEntry(in);
        VORegistryHandler vORegistryHandler = this;
        synchronized (vORegistryHandler) {
            this.registeredEndpoints.put(eprAddress, in);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Calendar refreshMember(String toRefresh) {
        AddDocument add;
        VORegistryHandler vORegistryHandler = this;
        synchronized (vORegistryHandler) {
            add = this.registeredEndpoints.get(toRefresh);
        }
        if (add == null) {
            throw new IllegalStateException("Trying to refresh unknown resource " + toRefresh);
        }
        try {
            ExternalRegistryClient client = this.getExternalRegistryClient();
            return client.addRegistryEntry(add);
        }
        catch (Exception e) {
            logger.warn((Object)("Can't update resource entry in the VO registry " + toRefresh), (Throwable)e);
            Calendar responseTT = Calendar.getInstance();
            responseTT.add(13, 300);
            return responseTT;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMember(String toRemoveAddress) {
        try {
            ExternalRegistryClient client = this.getExternalRegistryClient();
            List entries = client.listEntries();
            for (EntryType entry : entries) {
                if (!entry.getMemberServiceEPR().getAddress().getStringValue().equals(toRemoveAddress)) continue;
                this.deregister(entry.getServiceGroupEntryEPR());
                break;
            }
        }
        catch (Exception e) {
            logger.warn((Object)("Can't remove resource from VO registry " + toRemoveAddress), (Throwable)e);
        }
        VORegistryHandler vORegistryHandler = this;
        synchronized (vORegistryHandler) {
            this.registeredEndpoints.remove(toRemoveAddress);
        }
    }

    private void deregister(EndpointReferenceType sgeEpr) {
        try {
            BaseWSRFClient sgeClient = new BaseWSRFClient(sgeEpr, (IClientConfiguration)this.kernel.getClientConfiguration());
            sgeClient.destroy();
        }
        catch (Exception e) {
            logger.warn((Object)("Can't remove SGE from external VO registry " + sgeEpr.getAddress().getStringValue()), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExternalRegistryClient getExternalRegistryClient() throws Exception {
        ExternalRegistryClient reg = new ExternalRegistryClient();
        Set<String> set = this.externalRegistryURLs;
        synchronized (set) {
            for (String url : this.externalRegistryURLs) {
                reg.addClient((BaseWSRFClient)new RegistryClient(url, this.getEPR(this.kernel, url), (IClientConfiguration)this.kernel.getClientConfiguration()));
            }
        }
        reg.setMode(1);
        return reg;
    }

    private EndpointReferenceType getEPR(Kernel kernel, String address) {
        EndpointReferenceType myEPR = WSServerUtilities.newEPR(kernel.getContainerSecurityConfiguration());
        myEPR.addNewAddress().setStringValue(address);
        return myEPR;
    }
}

