/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.wsrflite.xmlbeans.registry;

import de.fzj.unicore.wsrflite.Kernel;
import de.fzj.unicore.wsrflite.Resource;
import de.fzj.unicore.wsrflite.ThreadingServices;
import de.fzj.unicore.wsrflite.utils.WSServerUtilities;
import de.fzj.unicore.wsrflite.xmlbeans.impl.VODescriptionExt;
import de.fzj.unicore.wsrflite.xmlbeans.registry.RegistryEntryUpdater;
import de.fzj.unicore.wsrflite.xmlbeans.registry.VORegistryHandler;
import eu.unicore.security.OperationType;
import eu.unicore.util.Log;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.XmlObject;
import org.oasisOpen.docs.wsrf.sg2.ContentType;
import org.unigrids.services.atomic.types.AllowedAccessTypesDocument;
import org.unigrids.services.atomic.types.AllowedAccessTypesType;

public class VORegistries
implements Runnable {
    private static final Logger log = Log.getLogger((String)"unicore.wsrflite", VORegistries.class);
    private Kernel kernel;
    private Map<String, VORegistryHandler> handlersByVO = new HashMap<String, VORegistryHandler>();
    private Map<String, Set<String>> resourcesByVO = new HashMap<String, Set<String>>();

    public VORegistries(Kernel kernel) {
        this.kernel = kernel;
        ThreadingServices ts = kernel.getContainerProperties().getThreadingServices();
        ts.getScheduledExecutorService().schedule(this, 18L, TimeUnit.SECONDS);
    }

    public synchronized void addSharedResource(VODescriptionExt voDesc, Resource resource, Set<OperationType> opTypes) throws Exception {
        ContentType content = this.getContent(opTypes);
        VORegistryHandler handler = this.handlersByVO.get(voDesc.getVoName());
        String regUrl = voDesc.getVoRegistry().getAddress().getStringValue();
        if (handler == null) {
            handler = new VORegistryHandler(this.kernel, regUrl);
            this.handlersByVO.put(voDesc.getVoName(), handler);
        }
        handler.setExternalRegistryURLs(regUrl);
        log.debug((Object)("Adding resource " + resource + " to VO " + (Object)((Object)voDesc) + " registry " + voDesc.getVoRegistry().getAddress().getStringValue()));
        handler.addMember(VORegistries.getEPRAddress(this.kernel, resource), content);
        Set<String> resources = this.resourcesByVO.get(voDesc.getVoName());
        if (resources == null) {
            resources = new HashSet<String>();
            this.resourcesByVO.put(voDesc.getVoName(), resources);
        }
        resources.add(VORegistries.getEPRAddress(this.kernel, resource));
    }

    public synchronized void removeSharedResource(String vo, String resourceAddress) {
        Set<String> resources = this.resourcesByVO.get(vo);
        if (resources != null) {
            log.debug((Object)("Removing resource " + resourceAddress + " from VO " + vo + " and its registry"));
            resources.remove(resourceAddress);
            VORegistryHandler handler = this.handlersByVO.get(vo);
            handler.removeMember(resourceAddress);
            if (resources.size() == 0) {
                this.resourcesByVO.remove(vo);
                this.handlersByVO.remove(vo);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Calendar next = Calendar.getInstance();
        next.add(13, 300);
        VORegistries vORegistries = this;
        synchronized (vORegistries) {
            for (String vo : this.resourcesByVO.keySet()) {
                Set<String> resources = this.resourcesByVO.get(vo);
                VORegistryHandler handler = this.handlersByVO.get(vo);
                for (String resource : resources) {
                    if (!RegistryEntryUpdater.wsrfResourceExists(this.kernel, resource)) {
                        log.debug((Object)("Resource " + resource + " does not exists anymore, removeing it from VO"));
                        this.removeSharedResource(vo, resource);
                        continue;
                    }
                    log.debug((Object)("Refreshing " + resource + " entry in VO registry"));
                    Calendar tmp = handler.refreshMember(resource);
                    if (!tmp.before(next)) continue;
                    next = tmp;
                }
            }
        }
        ThreadingServices ts = this.kernel.getContainerProperties().getThreadingServices();
        long delay = next.getTimeInMillis() - System.currentTimeMillis();
        log.debug((Object)("Sheduling next iteration of VO registries update in " + delay + "ms"));
        ts.getScheduledExecutorService().schedule(this, delay, TimeUnit.MILLISECONDS);
    }

    private ContentType getContent(Set<OperationType> opTypes) {
        AllowedAccessTypesDocument allowedAccessDoc = AllowedAccessTypesDocument.Factory.newInstance();
        AllowedAccessTypesType allowedAccess = allowedAccessDoc.addNewAllowedAccessTypes();
        for (OperationType op : opTypes) {
            allowedAccess.addAllowedAccessType(op.toString());
        }
        ContentType content = ContentType.Factory.newInstance();
        content.addNewRPDoc().set((XmlObject)allowedAccessDoc);
        return content;
    }

    public static String getEPRAddress(Kernel kernel, Resource r) {
        return WSServerUtilities.makeAddress(r.getServiceName(), r.getUniqueID(), kernel.getContainerProperties());
    }
}

