/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.wsrflite.xmlbeans.registry;

import de.fzj.unicore.wsrflite.messaging.PullPoint;
import de.fzj.unicore.wsrflite.utils.WSServerUtilities;
import de.fzj.unicore.wsrflite.xmlbeans.exceptions.ResourceNotDestroyedFault;
import de.fzj.unicore.wsrflite.xmlbeans.exceptions.ResourceUnavailableFault;
import de.fzj.unicore.wsrflite.xmlbeans.exceptions.ResourceUnknownFault;
import de.fzj.unicore.wsrflite.xmlbeans.exceptions.TerminationTimeChangeRejectedFault;
import de.fzj.unicore.wsrflite.xmlbeans.exceptions.UnableToSetTerminationTimeFault;
import de.fzj.unicore.wsrflite.xmlbeans.sg.Registry;
import de.fzj.unicore.wsrflite.xmlbeans.sg.impl.EntryResourceProperty;
import de.fzj.unicore.wsrflite.xmlbeans.sg.impl.ServiceGroupRegistrationImpl;
import eu.unicore.util.Log;
import java.util.Map;
import org.apache.log4j.Logger;
import org.oasisOpen.docs.wsrf.rl2.DestroyDocument;
import org.oasisOpen.docs.wsrf.rl2.DestroyResponseDocument;
import org.oasisOpen.docs.wsrf.rl2.SetTerminationTimeDocument;
import org.oasisOpen.docs.wsrf.rl2.SetTerminationTimeResponseDocument;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

public class RegistryImpl
extends ServiceGroupRegistrationImpl
implements Registry {
    private static final Logger logger = Log.getLogger((String)"unicore.services", RegistryImpl.class);

    @Override
    protected EndpointReferenceType createServiceGroupEntry(Map<String, Object> arg0) throws Exception {
        EndpointReferenceType epr = super.createServiceGroupEntry(arg0);
        WSServerUtilities.addUGSRefparamToEpr((EndpointReferenceType)epr);
        return epr;
    }

    public void postActivate() {
        try {
            PullPoint p = this.kernel.getMessaging().getPullPoint(this.getUniqueID());
            EntryResourceProperty erp = (EntryResourceProperty)((Object)this.properties.get(Registry.RPEntry));
            while (p.hasNext()) {
                String id = (String)((Object)p.next().getBody());
                logger.debug((Object)("Removing entry with id=" + id));
                erp.deleteEntry(id);
                this.setDirty();
            }
        }
        catch (Exception e) {
            Log.logException((String)"Could not remove entry.", (Throwable)e, (Logger)logger);
        }
    }

    @Override
    public DestroyResponseDocument Destroy(DestroyDocument in) throws ResourceNotDestroyedFault, ResourceUnknownFault, ResourceUnavailableFault {
        throw ResourceNotDestroyedFault.createFault((String)"Not destroyed.");
    }

    @Override
    public SetTerminationTimeResponseDocument SetTerminationTime(SetTerminationTimeDocument in) throws UnableToSetTerminationTimeFault, TerminationTimeChangeRejectedFault, ResourceUnknownFault, ResourceUnavailableFault {
        throw TerminationTimeChangeRejectedFault.createFault((String)"Not changed.");
    }
}

