/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.wsrflite.xmlbeans.registry;

import de.fzj.unicore.persist.PersistenceException;
import de.fzj.unicore.persist.impl.LockSupport;
import de.fzj.unicore.wsrflite.Home;
import de.fzj.unicore.wsrflite.Kernel;
import de.fzj.unicore.wsrflite.exceptions.ResourceNotCreatedException;
import de.fzj.unicore.wsrflite.exceptions.ResourceUnknownException;
import de.fzj.unicore.wsrflite.xmlbeans.impl.WSResourceImpl;
import de.fzj.unicore.wsrflite.xmlbeans.registry.RegistryHandler;
import de.fzj.unicore.wsrflite.xmlbeans.registry.RegistryHomeImpl;
import eu.unicore.util.Log;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.concurrent.locks.Lock;
import org.apache.log4j.Logger;

public class RegistryCreator {
    private static final Logger logger = Log.getLogger((String)"unicore.services", RegistryCreator.class);
    public static final String DEFAULT_REGISTRY_ID = "default_registry";
    private boolean isGlobalRegistry;
    private final Kernel kernel;

    public RegistryCreator(Kernel kernel) {
        this.kernel = kernel;
        Home regHome = kernel.getHome("Registry");
        this.isGlobalRegistry = regHome != null && regHome instanceof RegistryHomeImpl;
    }

    public boolean isGlobalRegistry() {
        return this.isGlobalRegistry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createRegistry() throws PersistenceException {
        Home regHome = this.kernel.getHome("Registry");
        if (regHome == null) {
            logger.info((Object)"No Registry service configured for this site.");
            return;
        }
        LockSupport ls = this.kernel.getPersistenceManager().getLockSupport();
        Lock regLock = ls.getOrCreateLock(RegistryHandler.class.getName());
        if (regLock.tryLock()) {
            try {
                try {
                    regHome.get(DEFAULT_REGISTRY_ID);
                    logger.debug((Object)"Registry has already been set up.");
                }
                catch (ResourceUnknownException e) {
                    try {
                        logger.debug((Object)"Trying to start up registry.");
                        this.createRegistryInstance(regHome);
                    }
                    catch (Exception ex) {
                        logger.warn((Object)"Could not start up registry!", (Throwable)ex);
                    }
                }
            }
            finally {
                regLock.unlock();
            }
        }
    }

    private void createRegistryInstance(Home regHome) throws ResourceNotCreatedException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(WSResourceImpl.INIT_UNIQUE_ID, DEFAULT_REGISTRY_ID);
        GregorianCalendar c1 = new GregorianCalendar();
        ((Calendar)c1).add(2, 36);
        map.put("de.fzj.unicore.wsrflite.terminationtime.initialvalue", c1);
        regHome.createWSRFServiceInstance(map);
        logger.debug((Object)"Added 'default_registry' resource to service Registry");
    }
}

