/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.wsrflite.xmlbeans.registry;

import de.fzj.unicore.wsrflite.xmlbeans.BaseFault;
import de.fzj.unicore.wsrflite.xmlbeans.client.ExternalRegistryClient;
import de.fzj.unicore.wsrflite.xmlbeans.registry.RegistryHandler;
import de.fzj.unicore.wsrflite.xmlbeans.registry.RegistryImpl;
import eu.unicore.util.Log;
import java.util.Calendar;
import org.apache.log4j.Logger;
import org.oasisOpen.docs.wsrf.sg2.AddDocument;
import org.oasisOpen.docs.wsrf.sg2.AddResponseDocument;

public class LocalRegistryImpl
extends RegistryImpl {
    private static final Logger logger = Log.getLogger((String)"unicore.services", LocalRegistryImpl.class);
    protected static final long readd_offset = 60000L;

    @Override
    public AddResponseDocument Add(AddDocument in) throws BaseFault {
        logger.debug((Object)"Adding entry to local registry.");
        Calendar terminationTime = null;
        Object o = in.getAdd().getInitialTerminationTime();
        if (o != null) {
            terminationTime = this.makeCalendar(o);
        } else {
            terminationTime = Calendar.getInstance();
            terminationTime.add(12, 5);
        }
        RegistryHandler rh = (RegistryHandler)this.kernel.getAttribute(RegistryHandler.class);
        if (rh.usesExternalRegistry()) {
            try {
                logger.debug((Object)"Trying to add entry to external registry.");
                ExternalRegistryClient externalRegistryClient = rh.getExternalRegistryClient();
                terminationTime = externalRegistryClient.addRegistryEntry(in);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Will try to re-add entry for " + in.getAdd().getMemberEPR().getAddress().getStringValue() + " at: " + terminationTime.getTime().toString()));
                }
            }
            catch (Exception e) {
                Log.logException((String)"Could not connect to external Registry!", (Throwable)e, (Logger)logger);
            }
            in.getAdd().setInitialTerminationTime((Object)terminationTime);
        }
        return super.Add(in);
    }
}

