/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.wsrflite.xmlbeans.impl;

import de.fzj.unicore.wsrflite.FaultConverter;
import de.fzj.unicore.wsrflite.exceptions.ResourceUnavailableException;
import de.fzj.unicore.wsrflite.exceptions.ResourceUnknownException;
import de.fzj.unicore.wsrflite.exceptions.TerminationTimeChangeRejectedException;
import de.fzj.unicore.wsrflite.exceptions.UnableToSetTerminationTimeException;
import de.fzj.unicore.wsrflite.xmlbeans.BaseFault;
import de.fzj.unicore.wsrflite.xmlbeans.exceptions.ResourceUnavailableFault;
import de.fzj.unicore.wsrflite.xmlbeans.exceptions.ResourceUnknownFault;
import de.fzj.unicore.wsrflite.xmlbeans.exceptions.TerminationTimeChangeRejectedFault;
import de.fzj.unicore.wsrflite.xmlbeans.exceptions.UnableToSetTerminationTimeFault;

public class XmlBeansFaultConverter
implements FaultConverter {
    private static XmlBeansFaultConverter inst;

    public Exception convert(Exception e) {
        if (e instanceof ResourceUnknownException) {
            String msg = e.getMessage();
            return ResourceUnknownFault.createFault((String)(msg != null ? "Resource unknown: " + msg : "Resource unknown."));
        }
        if (e instanceof ResourceUnavailableException) {
            String msg = e.getMessage();
            return ResourceUnavailableFault.createFault((String)(msg != null ? "Resource unavailable: " + msg : "Resource unavailable."));
        }
        if (e instanceof TerminationTimeChangeRejectedException) {
            String msg = e.getMessage();
            return TerminationTimeChangeRejectedFault.createFault((String)(msg != null ? "TT change rejected: " + msg : "TT change rejected"));
        }
        if (e instanceof UnableToSetTerminationTimeException) {
            String msg = e.getMessage();
            return UnableToSetTerminationTimeFault.createFault((String)(msg != null ? "Could not set TT: " + msg : "Could not set TT"));
        }
        return BaseFault.createFault((String)e.getMessage(), (Throwable)e);
    }

    public static synchronized XmlBeansFaultConverter getInstance() {
        if (inst == null) {
            inst = new XmlBeansFaultConverter();
        }
        return inst;
    }
}

