/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.wsrflite.xmlbeans.impl;

import de.fzj.unicore.wsrflite.impl.SecuredResourceImpl;
import de.fzj.unicore.wsrflite.security.IContainerSecurityConfiguration;
import de.fzj.unicore.wsrflite.security.VODescription;
import de.fzj.unicore.wsrflite.security.util.AuthZAttributeStore;
import de.fzj.unicore.wsrflite.xmlbeans.ResourceProperty;
import de.fzj.unicore.wsrflite.xmlbeans.impl.WSResourceImpl;
import eu.unicore.security.Client;
import eu.unicore.security.Xlogin;
import eu.unicore.util.Log;
import java.io.StringWriter;
import java.io.Writer;
import java.security.cert.X509Certificate;
import org.apache.log4j.Logger;
import org.bouncycastle.openssl.PEMWriter;
import org.unigrids.services.atomic.types.AcceptedCAsType;
import org.unigrids.services.atomic.types.AcceptedVOsType;
import org.unigrids.services.atomic.types.SecurityDocument;
import org.unigrids.services.atomic.types.SecurityType;
import org.unigrids.services.atomic.types.SelectedXGroupType;
import org.unigrids.services.atomic.types.VOType;
import org.unigrids.services.atomic.types.ValidRolesType;
import org.unigrids.services.atomic.types.ValidVOsType;
import org.unigrids.services.atomic.types.ValidXgroupsType;
import org.unigrids.services.atomic.types.ValidXloginsType;

public class SecurityInfoResourceProperty
extends ResourceProperty<Object> {
    private static final Logger logger = Log.getLogger((String)"unicore.services", SecurityInfoResourceProperty.class);
    private static final long serialVersionUID = 1L;
    private SecurityDocument[] xdoc;
    private final boolean addServerCert;

    public SecurityInfoResourceProperty(WSResourceImpl parent, boolean addServerCert) {
        super(parent);
        this.addServerCert = addServerCert;
        this.xdoc = new SecurityDocument[1];
        this.xdoc[0] = SecurityDocument.Factory.newInstance();
        this.xdoc[0].addNewSecurity();
        this.doGetInfo();
    }

    public SecurityDocument[] getXml() {
        return this.xdoc;
    }

    @Override
    public SecurityInfoResourceProperty update() {
        this.doGetInfo();
        return this;
    }

    protected void doGetInfo() {
        String[] trustedIssuers;
        IContainerSecurityConfiguration securityCfg = this.parentWSResource.getKernel().getContainerSecurityConfiguration();
        if (this.addServerCert) {
            try {
                X509Certificate c = securityCfg.getCredential().getCertificate();
                if (c != null) {
                    StringWriter writer = new StringWriter();
                    PEMWriter pw = new PEMWriter((Writer)writer);
                    pw.writeObject((Object)c);
                    pw.flush();
                    this.xdoc[0].getSecurity().setServerCertificate(writer.toString());
                }
            }
            catch (Exception ex) {
                Log.logException((String)"Error getting server cert", (Throwable)ex, (Logger)logger);
            }
        }
        if (securityCfg.getCredential() != null) {
            String serverDN = securityCfg.getCredential().getSubjectName();
            this.xdoc[0].getSecurity().setServerDN(serverDN);
        }
        if ((trustedIssuers = this.getTrustedIssuers(securityCfg)).length > 0) {
            AcceptedCAsType acceptedCAs = AcceptedCAsType.Factory.newInstance();
            acceptedCAs.setAcceptedCAArray(trustedIssuers);
            this.xdoc[0].getSecurity().setAcceptedCAs(acceptedCAs);
        }
        try {
            VODescription[] vos = securityCfg.getAip().getAcceptedVOs();
            if (vos != null && vos.length > 0) {
                AcceptedVOsType acceptedVOs = AcceptedVOsType.Factory.newInstance();
                for (VODescription voDesc : vos) {
                    VOType xmlVo = acceptedVOs.addNewVO();
                    xmlVo.setVoName(voDesc.getVoName());
                    xmlVo.setVoServer(voDesc.getVoServiceURI());
                }
                this.xdoc[0].getSecurity().setAcceptedVOs(acceptedVOs);
            }
        }
        catch (Exception ex) {
            Log.logException((String)"Error getting vo list", (Throwable)ex, (Logger)logger);
        }
        this.setValidSettings();
        this.setSelectedSettings();
        if (this.parentWSResource instanceof SecuredResourceImpl) {
            try {
                String owner = ((SecuredResourceImpl)this.parentWSResource).getOwner().getName();
                this.xdoc[0].getSecurity().setOwnerDN(owner);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected String[] getTrustedIssuers(IContainerSecurityConfiguration securityCfg) {
        if (securityCfg.getValidator() == null) {
            return new String[0];
        }
        X509Certificate[] trusted = securityCfg.getValidator().getTrustedIssuers();
        if (trusted != null && trusted.length > 0) {
            String[] trustedIssuers = new String[trusted.length];
            for (int i = 0; i < trusted.length; ++i) {
                trustedIssuers[i] = trusted[i].getSubjectX500Principal().getName();
            }
            return trustedIssuers;
        }
        return new String[0];
    }

    protected void setValidSettings() {
        String[] validRoles;
        String[] xlogins;
        String[] groups;
        Client client = AuthZAttributeStore.getClient();
        String[] vos = client.getVos();
        if (vos != null && vos.length > 0) {
            ValidVOsType clientValidVos = ValidVOsType.Factory.newInstance();
            clientValidVos.setVOArray(vos);
            this.xdoc[0].getSecurity().setClientValidVOs(clientValidVos);
        }
        if ((groups = client.getXlogin().getGroups()) != null && groups.length > 0) {
            ValidXgroupsType validXgroups = ValidXgroupsType.Factory.newInstance();
            validXgroups.setXgroupArray(groups);
            this.xdoc[0].getSecurity().setClientValidXgroups(validXgroups);
        }
        if ((xlogins = client.getXlogin().getLogins()) != null && xlogins.length > 0) {
            ValidXloginsType validXlogins = ValidXloginsType.Factory.newInstance();
            validXlogins.setXloginArray(xlogins);
            this.xdoc[0].getSecurity().setClientValidXlogins(validXlogins);
        }
        if ((validRoles = client.getRole().getValidRoles()) != null && validRoles.length > 0) {
            ValidRolesType validRolesXml = ValidRolesType.Factory.newInstance();
            validRolesXml.setRoleArray(validRoles);
            this.xdoc[0].getSecurity().setClientValidRoles(validRolesXml);
        }
    }

    protected void setSelectedSettings() {
        String vo;
        Client client = AuthZAttributeStore.getClient();
        SecurityType sec = this.xdoc[0].getSecurity();
        String role = client.getRole().getName();
        sec.setClientSelectedRole(role);
        String xlogin = client.getSelectedXloginName();
        if (xlogin != null) {
            sec.setClientSelectedXlogin(xlogin);
        }
        if ((vo = client.getVo()) != null) {
            sec.setClientSelectedVO(vo);
        }
        this.setSelectedGroup();
        sec.setClientDN(client.getDistinguishedName());
    }

    protected void setSelectedGroup() {
        String[] supGroups;
        Client client = AuthZAttributeStore.getClient();
        Xlogin xloginO = client.getXlogin();
        boolean useOs = xloginO.isAddDefaultGroups();
        SelectedXGroupType selectedXGroup = SelectedXGroupType.Factory.newInstance();
        selectedXGroup.setUseOSDefaults(useOs);
        if (xloginO.isGroupSelected()) {
            selectedXGroup.setPrimaryGroup(xloginO.getGroup());
        }
        if ((supGroups = xloginO.getSelectedSupplementaryGroups()) != null && supGroups.length > 0) {
            selectedXGroup.setSupplementaryGroupArray(supGroups);
        }
        this.xdoc[0].getSecurity().setClientSelectedXgroup(selectedXGroup);
    }
}

