/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.wsrflite.xmlbeans;

import de.fzj.unicore.wsrflite.exceptions.InvalidModificationException;
import de.fzj.unicore.wsrflite.xmlbeans.ResourceProperty;
import de.fzj.unicore.wsrflite.xmlbeans.impl.WSResourceImpl;
import eu.unicore.util.Log;
import java.lang.reflect.Array;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.SchemaProperty;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.XmlBeans;
import org.apache.xmlbeans.XmlObject;

public class ModifiableResourceProperty<T extends XmlObject, K>
extends ResourceProperty<K> {
    private static final long serialVersionUID = 1L;
    protected static final Logger logger = Log.getLogger((String)"unicore.services", ModifiableResourceProperty.class);
    protected boolean checkSchema;
    protected BigInteger minOccurs = BigInteger.ONE;
    protected BigInteger maxOccurs = BigInteger.ONE;
    private ArrayList<T> xdoc;
    private Object[] foo;

    public ModifiableResourceProperty(QName type, WSResourceImpl parent, boolean checkSchema, int min, int max) {
        super(parent);
        this.constructorCommon(checkSchema, type);
        this.minOccurs = BigInteger.valueOf(min);
        this.maxOccurs = BigInteger.valueOf(max);
    }

    public ModifiableResourceProperty(QName type, WSResourceImpl parent, boolean checkSchema) {
        super(parent);
        this.constructorCommon(checkSchema, type);
        if (checkSchema) {
            this.extractSchemaInfo(type, parent);
        }
    }

    public ModifiableResourceProperty(QName type, WSResourceImpl parent) {
        this(type, parent, false);
    }

    private void constructorCommon(boolean checkSchema, QName type) {
        this.checkSchema = checkSchema;
        this.xdoc = new ArrayList();
        SchemaType st = XmlBeans.getContextTypeLoader().findDocumentType(type);
        this.foo = (Object[])Array.newInstance(st.getJavaClass(), 0);
    }

    private void extractSchemaInfo(QName type, WSResourceImpl parent) {
        try {
            QName propertiesDocumentType = parent.getResourcePropertyDocumentQName();
            SchemaType rpDocSchemaType = XmlBeans.getContextTypeLoader().findDocumentType(propertiesDocumentType);
            if (rpDocSchemaType != null) {
                SchemaProperty sp = rpDocSchemaType.getElementProperty(type);
                if (sp != null) {
                    this.minOccurs = sp.getMinOccurs();
                    this.maxOccurs = sp.getMaxOccurs();
                } else {
                    logger.warn((Object)("No schema type found for type " + type + " in properties document " + propertiesDocumentType));
                }
            } else {
                logger.warn((Object)("No schema type found for QName " + propertiesDocumentType));
            }
        }
        catch (Exception e) {
            logger.warn((Object)"Can't setup resource property: ", (Throwable)e);
        }
    }

    @Override
    public T[] getXml() {
        return (XmlObject[])this.xdoc.toArray(this.foo);
    }

    public void insert(T o) throws InvalidModificationException {
        if (this.checkSchema) {
            this.checkSchema(this.xdoc.size() + 1);
        }
        this.xdoc.add(o);
        ((WSResourceImpl)this.parentWSResource).setDirty();
    }

    public void update(List<T> o) throws InvalidModificationException {
        if (this.checkSchema) {
            this.checkSchema(o.size());
        }
        this.xdoc.clear();
        for (XmlObject t : o) {
            this.xdoc.add(t);
        }
        ((WSResourceImpl)this.parentWSResource).setDirty();
    }

    public void delete() throws InvalidModificationException {
        if (this.checkSchema) {
            this.checkSchema(0);
        }
        this.xdoc.clear();
        ((WSResourceImpl)this.parentWSResource).setDirty();
    }

    protected void checkSchema(int cardinality) throws InvalidModificationException {
        BigInteger c = BigInteger.valueOf(cardinality);
        if (this.minOccurs.compareTo(c) > 0 || this.maxOccurs.compareTo(c) < 0) {
            throw new InvalidModificationException("The number of resource property elements must be between " + this.minOccurs + " and " + this.maxOccurs);
        }
    }

    public boolean checkPermissions(int permissions) {
        return true;
    }
}

