/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.wsrflite.xfire.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import org.codehaus.xfire.wsdl.WSDLWriter;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.filter.ElementFilter;
import org.jdom.filter.Filter;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class CachingWSDLWriter
implements WSDLWriter {
    private Document doc;
    private final XMLOutputter outputter = new XMLOutputter(Format.getPrettyFormat());
    private final WSDLWriter source;
    private final String baseUrl;

    public CachingWSDLWriter(WSDLWriter source, String baseUrl) {
        this.source = source;
        this.baseUrl = baseUrl;
    }

    public void write(OutputStream out) throws IOException {
        if (this.doc == null) {
            this.processWSDL(this.source);
        }
        this.outputter.output(this.doc, out);
    }

    private synchronized void processWSDL(WSDLWriter wsdl) throws IOException {
        if (this.doc != null) {
            return;
        }
        ByteArrayOutputStream temp = new ByteArrayOutputStream();
        wsdl.write((OutputStream)temp);
        SAXBuilder builder = new SAXBuilder();
        try {
            this.doc = builder.build((InputStream)new ByteArrayInputStream(temp.toByteArray()));
            ElementFilter filter = new ElementFilter("address", Namespace.getNamespace((String)"http://schemas.xmlsoap.org/wsdl/soap/"));
            Iterator descendants = this.doc.getDescendants((Filter)filter);
            while (descendants.hasNext()) {
                Element serviceaddress = (Element)descendants.next();
                Attribute location = serviceaddress.getAttribute("location");
                String serviceName = location.getValue().substring(location.getValue().lastIndexOf("/"));
                location.setValue(this.baseUrl + serviceName);
            }
        }
        catch (JDOMException e) {
            throw new IOException("tried to parse original wsdl failed");
        }
    }
}

