/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.wsrflite.xfire.security;

import de.fzj.unicore.wsrflite.Home;
import de.fzj.unicore.wsrflite.Kernel;
import de.fzj.unicore.wsrflite.impl.ResourceImpl;
import de.fzj.unicore.wsrflite.security.SecurityManager;
import de.fzj.unicore.wsrflite.security.VODescription;
import de.fzj.unicore.wsrflite.security.pdp.ActionDescriptor;
import de.fzj.unicore.wsrflite.security.util.AuthZAttributeStore;
import de.fzj.unicore.wsrflite.security.util.ResourceDescriptor;
import de.fzj.unicore.wsrflite.xfire.WSRFHandler;
import de.fzj.unicore.wsrflite.xfire.WSRFInvoker;
import eu.unicore.security.AuthorisationException;
import eu.unicore.security.Client;
import eu.unicore.security.OperationType;
import eu.unicore.security.SecurityTokens;
import eu.unicore.security.xfireutil.AuthInHandler;
import eu.unicore.util.Log;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;
import org.codehaus.xfire.MessageContext;
import org.codehaus.xfire.handler.AbstractHandler;

public class AccessControlHandler
extends AbstractHandler {
    private static final Logger logger = Log.getLogger((String)"unicore.security", AccessControlHandler.class);
    private final Kernel kernel;
    private final SecurityManager securityManager;

    public AccessControlHandler(Kernel kernel) {
        this.kernel = kernel;
        this.securityManager = kernel.getSecurityManager();
        this.setPhase("pre-invoke");
        this.after(AuthInHandler.class.getName());
        this.after(WSRFHandler.class.getName());
    }

    public void invoke(MessageContext ctx) throws Exception {
        String serviceName = ctx.getService().getSimpleName();
        if (!this.isCheckingService(serviceName) || this.isLocalCall(ctx)) {
            return;
        }
        Home home = this.kernel.getHome(serviceName);
        if (home == null) {
            this.checkAccessPlainWS(ctx, serviceName);
        } else {
            this.checkAccessWSRF(ctx, serviceName);
        }
    }

    protected void checkAccessPlainWS(MessageContext ctx, String serviceName) {
        ResourceDescriptor resourceDescriptor = null;
        Client client = null;
        String action = this.getAction(ctx);
        try {
            client = this.createClient(ctx);
            String owner = this.kernel.getContainerSecurityConfiguration().getCredential().getCertificate().getSubjectX500Principal().getName();
            resourceDescriptor = new ResourceDescriptor(serviceName, null, owner, null);
        }
        catch (AuthorisationException ae) {
            logger.warn((Object)ae.getMessage());
            AuthZAttributeStore.removeClient();
            throw ae;
        }
        catch (Exception e) {
            Log.logException((String)"Error setting up authorisation check", (Throwable)e, (Logger)logger);
            AuthZAttributeStore.removeClient();
            throw new AuthorisationException("Authorisation failed. Reason: " + e.getMessage());
        }
        this.doCheck(client, action, OperationType.modify, resourceDescriptor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkAccessWSRF(MessageContext context, String serviceName) {
        ResourceDescriptor resourceDescriptor = null;
        Client client = null;
        String action = this.getAction(context);
        String uniqueID = "unknown";
        Object target = context.getProperty(WSRFInvoker.KEY);
        HashMap voMembership = null;
        OperationType opType = null;
        try {
            if (target instanceof ResourceImpl) {
                ResourceImpl wsr = (ResourceImpl)target;
                uniqueID = wsr.getUniqueID();
                Map srcVoMembership = wsr.getExtendedVOMembership();
                voMembership = new HashMap();
                Map map = srcVoMembership;
                synchronized (map) {
                    for (VODescription voDesc : srcVoMembership.keySet()) {
                        HashSet v = new HashSet();
                        v.addAll((Collection)srcVoMembership.get(voDesc));
                        voMembership.put(voDesc.getVoName(), v);
                    }
                }
            } else {
                throw new AuthorisationException("Security check can't be performed on service class <" + target.getClass().getName() + ">, this is not a WSRFlite service!");
            }
            opType = this.getActionType(serviceName, context);
            ResourceImpl i = (ResourceImpl)target;
            SecurityTokens securityTokens = (SecurityTokens)context.getProperty(SecurityTokens.KEY);
            if (securityTokens != null) {
                i.updateSecurityTokensBeforeAIP(securityTokens);
            }
            client = this.createClient(context);
            String owner = i.getOwner().getName();
            resourceDescriptor = new ResourceDescriptor(serviceName, uniqueID, owner, voMembership);
        }
        catch (AuthorisationException ae) {
            logger.warn((Object)ae.getMessage());
            AuthZAttributeStore.removeClient();
            throw ae;
        }
        catch (Exception e) {
            String msg = Log.createFaultMessage((String)("Error setting up access control check: " + e.getMessage()), (Throwable)e);
            logger.warn((Object)msg, (Throwable)e);
            AuthZAttributeStore.removeClient();
            throw new AuthorisationException(msg, (Throwable)e);
        }
        this.doCheck(client, action, opType, resourceDescriptor);
    }

    protected Client createClient(MessageContext context) {
        SecurityTokens securityTokens = (SecurityTokens)context.getProperty(SecurityTokens.KEY);
        if (securityTokens == null) {
            throw new AuthorisationException("Security check can't be performed as no security tokens are present. Probably the server is misconfigured.");
        }
        Client client = this.securityManager.createClientWithAttributes(securityTokens);
        AuthZAttributeStore.setClient((Client)client);
        return client;
    }

    protected void doCheck(Client client, String action, OperationType actionType, ResourceDescriptor rd) {
        SecurityTokens securityTokens = client.getSecurityTokens();
        if (!securityTokens.isConsignorTrusted()) {
            throw new AuthorisationException("Consignor is trying to invoke an operation on User's behalf without trust delegation from the User.");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Checking access on service " + rd));
        }
        if (this.securityManager.isServer(client)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Accept server-scope action <" + action + "> on " + rd));
            }
            return;
        }
        this.securityManager.getSignatureChecker().checkDigitalSignature(securityTokens, action, rd);
        this.securityManager.checkAuthorisation(client, new ActionDescriptor(action, actionType), rd);
        this.securityManager.collectDynamicAttributes(client);
    }

    public boolean isCheckingService(String serviceName) {
        return this.kernel.getContainerSecurityConfiguration().isAccessControlEnabled(serviceName);
    }

    private String getAction(MessageContext ctx) {
        Method method = ctx.getExchange().getOperation().getMethod();
        String action = null;
        action = method != null ? method.getName() : (String)ctx.getInMessage().getProperty((Object)"SOAPAction");
        return action;
    }

    private OperationType getActionType(String serviceName, MessageContext ctx) {
        Method method = ctx.getExchange().getOperation().getMethod();
        return this.securityManager.getOperationTypesUtil().getOperationType(serviceName, method.getName());
    }

    private boolean isLocalCall(MessageContext ctx) {
        String s = ctx.getInMessage().getChannel().getUri();
        return s != null && s.startsWith("xfire.local");
    }
}

