/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.wsrflite.xfire;

import de.fzj.unicore.wsrflite.Home;
import de.fzj.unicore.wsrflite.Kernel;
import de.fzj.unicore.wsrflite.Service;
import de.fzj.unicore.wsrflite.ServiceConfiguration;
import de.fzj.unicore.wsrflite.utils.deployment.DeploymentUtils;
import de.fzj.unicore.wsrflite.xfire.XFireKernel;
import eu.unicore.util.Log;
import org.apache.log4j.Logger;
import org.codehaus.xfire.handler.AbstractHandler;

public class XFireService
implements Service {
    private static final Logger logger = Log.getLogger((String)"unicore.services", XFireService.class);
    public static final String TYPE = "xfire";
    private final String name;
    private volatile boolean stopped = true;
    private Home home;
    private final Kernel kernel;
    private ClassLoader classLoader;
    private final ServiceConfiguration serviceConfiguration;

    public XFireService(ServiceConfiguration serviceConfiguration) {
        this.name = serviceConfiguration.getServiceName();
        this.kernel = serviceConfiguration.getKernel();
        this.serviceConfiguration = serviceConfiguration;
        this.classLoader = serviceConfiguration.getClassLoader();
    }

    public final ServiceConfiguration getServiceConfiguration() {
        return this.serviceConfiguration;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader cl) {
        this.classLoader = cl;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return TYPE;
    }

    public void start() throws Exception {
        Class<?> impl;
        Class<?> spec;
        if (!this.stopped) {
            logger.debug((Object)("Not starting service <+" + this.name + "> : already started."));
            return;
        }
        if (this.getClassLoader() != null) {
            spec = Class.forName(this.serviceConfiguration.getInterfaceClass(), true, this.classLoader);
            impl = Class.forName(this.serviceConfiguration.getImplementationClass(), true, this.classLoader);
        } else {
            spec = Class.forName(this.serviceConfiguration.getInterfaceClass());
            impl = Class.forName(this.serviceConfiguration.getImplementationClass());
        }
        boolean isWSRF = DeploymentUtils.isWSRF(impl);
        boolean isPersistent = this.serviceConfiguration.isPersistent();
        if (isWSRF) {
            this.kernel.getContainerProperties().setProperty("unicore.wsrflite.isPersistent." + this.name, Boolean.toString(isPersistent));
            this.home = (Home)impl.newInstance();
            this.home.setKernel(this.kernel);
            this.home.activateHome(this.name);
        }
        org.codehaus.xfire.service.Service xfireService = XFireKernel.get(this.kernel).exposeAsService(this.name, spec, impl, isWSRF, isPersistent);
        this.setupAdditionalHandlers(xfireService);
        logger.debug((Object)("Started service <+" + this.name + ">"));
    }

    protected void setupAdditionalHandlers(org.codehaus.xfire.service.Service xfireService) {
        for (String s : this.serviceConfiguration.getInHandlers()) {
            try {
                xfireService.getInHandlers().add(this.loadHandler(s));
            }
            catch (Exception ex) {
                logger.error((Object)("Could not add 'in' handler <" + s + "> for service <" + this.name + ">"), (Throwable)ex);
            }
        }
        for (String s : this.serviceConfiguration.getOutHandlers()) {
            try {
                xfireService.getOutHandlers().add(this.loadHandler(s));
            }
            catch (Exception ex) {
                logger.error((Object)("Could not add 'out' handler <" + s + "> for service <" + this.name + ">"), (Throwable)ex);
            }
        }
    }

    private AbstractHandler loadHandler(String name) throws Exception {
        Class<?> clazz = Class.forName(name);
        return (AbstractHandler)this.kernel.load(clazz);
    }

    public void stop() {
        this.stopped = XFireKernel.get(this.kernel).unregisterService(this.getName());
        if (this.home != null) {
            this.home.passivateHome();
        }
    }

    public void stopAndCleanup() {
        this.stop();
    }

    public Home getHome() {
        return this.home;
    }

    public void setHome(Home home) {
        this.home = home;
    }

    public boolean isStarted() {
        return !this.stopped;
    }

    public String getInterfaceClass() {
        return this.serviceConfiguration.getInterfaceClass();
    }
}

