/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.wsrflite.admin.service;

import de.fzj.unicore.metrix.IMetric;
import de.fzj.unicore.metrix.MetricRegistry;
import de.fzj.unicore.wsrflite.Home;
import de.fzj.unicore.wsrflite.Kernel;
import de.fzj.unicore.wsrflite.admin.AdminAction;
import de.fzj.unicore.wsrflite.admin.AdminActionResult;
import de.fzj.unicore.wsrflite.admin.service.AdminActionsRP;
import de.fzj.unicore.wsrflite.admin.service.MetricCategoriesRP;
import de.fzj.unicore.wsrflite.admin.service.MonitorEntriesRP;
import de.fzj.unicore.wsrflite.admin.service.ServiceEntriesRP;
import de.fzj.unicore.wsrflite.xmlbeans.AdminActionRequestDocument;
import de.fzj.unicore.wsrflite.xmlbeans.AdminActionResponseDocument;
import de.fzj.unicore.wsrflite.xmlbeans.AdminActionValueType;
import de.fzj.unicore.wsrflite.xmlbeans.AdminService;
import de.fzj.unicore.wsrflite.xmlbeans.BaseFault;
import de.fzj.unicore.wsrflite.xmlbeans.ClearMetricDataRequestDocument;
import de.fzj.unicore.wsrflite.xmlbeans.ClearMetricDataResponseDocument;
import de.fzj.unicore.wsrflite.xmlbeans.DeployServiceRequestDocument;
import de.fzj.unicore.wsrflite.xmlbeans.GetMetricRequestDocument;
import de.fzj.unicore.wsrflite.xmlbeans.GetMetricResponseDocument;
import de.fzj.unicore.wsrflite.xmlbeans.GetMetricsRequestDocument;
import de.fzj.unicore.wsrflite.xmlbeans.GetMetricsResponseDocument;
import de.fzj.unicore.wsrflite.xmlbeans.GetServiceInstancesRequestDocument;
import de.fzj.unicore.wsrflite.xmlbeans.GetServiceInstancesResponseDocument;
import de.fzj.unicore.wsrflite.xmlbeans.MetricValueDocument;
import de.fzj.unicore.wsrflite.xmlbeans.UndeployServiceRequestDocument;
import de.fzj.unicore.wsrflite.xmlbeans.impl.WSResourceImpl;
import eu.unicore.util.Log;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;

public class AdminServiceImpl
extends WSResourceImpl
implements AdminService {
    private static final Logger logger = Log.getLogger((String)"unicore.admin", AdminServiceImpl.class);

    public AdminServiceImpl(Kernel kernel, Home home) {
        this.kernel = kernel;
        this.home = home;
        this.properties.put(RPServiceEntryQName, new ServiceEntriesRP(this));
        this.properties.put(RPMonitorEntryQName, new MonitorEntriesRP(this));
        this.properties.put(RPAdminActionsQName, new AdminActionsRP(this));
        this.properties.put(RPMetricCategoryQName, new MetricCategoriesRP(this));
        try {
            super.initialise("AdminService", new HashMap<String, Object>());
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public QName getResourcePropertyDocumentQName() {
        return RPAdminServiceQName;
    }

    public void deployService(DeployServiceRequestDocument req) throws BaseFault {
        String serviceName = req.getDeployServiceRequest().getServiceName();
        boolean isPersistent = req.getDeployServiceRequest().isImmutable();
        byte[] jarAsBytes = req.getDeployServiceRequest().getJarFile();
        try {
            this.home.getKernel().getDeploymentManager().deployService(serviceName, jarAsBytes, isPersistent);
        }
        catch (Exception e) {
            Log.logException((String)("Deploying service <" + serviceName + "> failed."), (Throwable)e, (Logger)logger);
            throw BaseFault.createFault((String)Log.createFaultMessage((String)("Deploying service <" + serviceName + "> failed"), (Throwable)e));
        }
    }

    public void undeployService(UndeployServiceRequestDocument req) {
        String serviceName = req.getUndeployServiceRequest().getServiceName();
        try {
            this.home.getKernel().getDeploymentManager().undeployService(serviceName);
        }
        catch (Exception e) {
            Log.logException((String)("Undeploy service <" + serviceName + "> failed"), (Throwable)e, (Logger)logger);
        }
    }

    public GetServiceInstancesResponseDocument getServiceInstances(GetServiceInstancesRequestDocument req) throws BaseFault {
        try {
            String serviceName = req.getGetServiceInstancesRequest().getServiceName();
            Set uids = this.home.getKernel().getPersistenceManager().getPersist(serviceName).getUniqueIDs();
            GetServiceInstancesResponseDocument res = GetServiceInstancesResponseDocument.Factory.newInstance();
            res.addNewGetServiceInstancesResponse();
            res.getGetServiceInstancesResponse().setUidArray(uids.toArray(new String[uids.size()]));
            return res;
        }
        catch (Exception e) {
            Log.logException((String)e.getMessage(), (Throwable)e, (Logger)logger);
            throw BaseFault.createFault((String)"", (Throwable)e);
        }
    }

    public GetMetricsResponseDocument getMetrics(GetMetricsRequestDocument req) {
        IMetric[] metrics;
        String[] categories = req.getGetMetricsRequest().getCategoryArray();
        String[] mNames = req.getGetMetricsRequest().getNameArray();
        boolean filterByCategory = categories != null && categories.length > 0;
        boolean filterByName = mNames != null && mNames.length > 0;
        ArrayList metricNames = filterByName ? Arrays.asList(mNames) : new ArrayList();
        GetMetricsResponseDocument res = GetMetricsResponseDocument.Factory.newInstance();
        res.addNewGetMetricsResponse();
        HashSet<IMetric> theMetrics = new HashSet<IMetric>();
        if (!filterByCategory) {
            categories = MetricRegistry.getInstance().getMetricCategories();
        }
        for (IMetric metric : metrics = MetricRegistry.getInstance().getMetrics(categories)) {
            if (filterByName && !metricNames.contains(metric.getName())) continue;
            theMetrics.add(metric);
        }
        for (IMetric metric : theMetrics) {
            MetricValueDocument.MetricValue mv = res.getGetMetricsResponse().addNewMetricValue();
            this.fillXMLMetricValue(mv, metric);
        }
        return res;
    }

    public GetMetricResponseDocument getMetric(GetMetricRequestDocument req) {
        String name = req.getGetMetricRequest().getName();
        GetMetricResponseDocument res = GetMetricResponseDocument.Factory.newInstance();
        res.addNewGetMetricResponse();
        IMetric metric = MetricRegistry.getInstance().getMetric(name);
        if (metric != null) {
            MetricValueDocument.MetricValue mv = res.getGetMetricResponse().addNewMetricValue();
            this.fillXMLMetricValue(mv, metric);
        }
        return res;
    }

    private void fillXMLMetricValue(MetricValueDocument.MetricValue mv, IMetric<?> metric) {
        mv.setCategoryArray(metric.getCategories());
        mv.setName(metric.getName());
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(metric.getValue().getCaptureTime());
        mv.setTimestamp(c);
        mv.setUnits(metric.getMetricUnit());
        mv.setValue(metric.getResult().toString());
    }

    public ClearMetricDataResponseDocument clearMetricData(ClearMetricDataRequestDocument req) throws BaseFault {
        String metricName = req.getClearMetricDataRequest().getMetricName();
        try {
            MetricRegistry.getInstance().getMetric(metricName).clearData();
        }
        catch (Exception e) {
            Log.logException((String)("Clear metric data <" + metricName + "> failed."), (Throwable)e, (Logger)logger);
            throw BaseFault.createFault((String)"Clear metric data failed", (Throwable)e);
        }
        ClearMetricDataResponseDocument res = ClearMetricDataResponseDocument.Factory.newInstance();
        res.addNewClearMetricDataResponse();
        return res;
    }

    public AdminActionResponseDocument invokeAdminAction(AdminActionRequestDocument req) throws BaseFault {
        String name = req.getAdminActionRequest().getName();
        AdminAction action = (AdminAction)this.home.getKernel().getAdminActions().get(name);
        if (action == null) {
            throw BaseFault.createFault((String)("No admin action named <" + name + ">"));
        }
        HashMap<String, String> params = new HashMap<String, String>();
        for (AdminActionValueType r : req.getAdminActionRequest().getParameterArray()) {
            params.put(r.getName(), r.getValue());
        }
        logger.info((Object)("Invoking administrative action <" + name + "> :" + " client='" + this.getClient().getDistinguishedName() + "'" + " role=" + this.getClient().getRole().getName() + " parameters=" + params));
        AdminActionResult result = action.invoke(params, this.kernel);
        logger.info((Object)("Administrative action <" + name + "> success=" + result.successful() + " message='" + result.getMessage() + "' results=" + result.getResults() + " resultReferences=" + result.getResultReferences()));
        AdminActionResponseDocument response = AdminActionResponseDocument.Factory.newInstance();
        response.addNewAdminActionResponse();
        response.getAdminActionResponse().setSuccess(result.successful());
        response.getAdminActionResponse().setMessage(result.getMessage());
        for (Map.Entry e : result.getResults().entrySet()) {
            AdminActionValueType r = response.getAdminActionResponse().addNewResults();
            r.setName((String)e.getKey());
            r.setValue((String)e.getValue());
        }
        return response;
    }
}

