/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.uas.pdp.request.creator;

import eu.unicore.samly2.elements.NameID;
import eu.unicore.samly2.exceptions.SAMLProtocolException;
import eu.unicore.samly2.proto.AbstractRequest;
import eu.unicore.security.dsig.DSigException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import org.apache.xmlbeans.XmlException;
import org.w3c.dom.Document;
import xmlbeans.oasis.xacml.x2.x0.saml.assertion.XACMLAuthzDecisionQueryDocument;
import xmlbeans.org.oasis.saml2.protocol.RequestAbstractType;

public class AuhzDecisionRequest
extends AbstractRequest {
    private XACMLAuthzDecisionQueryDocument xbdoc;

    public AuhzDecisionRequest(XACMLAuthzDecisionQueryDocument src) throws SAMLProtocolException {
        super((RequestAbstractType)src.getXACMLAuthzDecisionQuery());
        this.xbdoc = src;
        this.parse();
    }

    public AuhzDecisionRequest(NameID issuer) {
        this.xbdoc = XACMLAuthzDecisionQueryDocument.Factory.newInstance();
        this.init(this.xbdoc.addNewXACMLAuthzDecisionQuery(), issuer);
    }

    public XACMLAuthzDecisionQueryDocument getDoc() {
        return this.xbdoc;
    }

    public boolean isCorrectlySigned(PublicKey key) throws DSigException {
        return this.isCorrectlySigned(key, (Document)this.xbdoc.getDomNode());
    }

    public void sign(PrivateKey pk, X509Certificate[] cert) throws DSigException {
        Document doc = this.signInt(pk, cert);
        try {
            this.xbdoc = XACMLAuthzDecisionQueryDocument.Factory.parse(doc);
            this.xmlReq = this.xbdoc.getXACMLAuthzDecisionQuery();
        }
        catch (XmlException e) {
            throw new DSigException("Parsing signed document failed", (Throwable)e);
        }
    }
}

