/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.uas.pdp.argus;

import eu.unicore.samly2.elements.NameID;
import eu.unicore.samly2.exceptions.SAMLProtocolException;
import eu.unicore.samly2.proto.AbstractRequest;
import eu.unicore.security.dsig.DSigException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import org.apache.xmlbeans.XmlException;
import org.w3c.dom.Document;
import xmlbeans.oasis.xacml.x2.x0.saml.assertion.XACMLPolicyQueryDocument;
import xmlbeans.org.oasis.saml2.protocol.RequestAbstractType;

public class PolicyRequest
extends AbstractRequest {
    private XACMLPolicyQueryDocument xbdoc;

    public PolicyRequest(XACMLPolicyQueryDocument src) throws SAMLProtocolException {
        super((RequestAbstractType)src.getXACMLPolicyQuery());
        this.xbdoc = src;
        this.parse();
    }

    public PolicyRequest(NameID issuer) {
        this.xbdoc = XACMLPolicyQueryDocument.Factory.newInstance();
        this.init(this.xbdoc.addNewXACMLPolicyQuery(), issuer);
    }

    public XACMLPolicyQueryDocument getDoc() {
        return this.xbdoc;
    }

    public boolean isCorrectlySigned(PublicKey key) throws DSigException {
        return this.isCorrectlySigned(key, (Document)this.xbdoc.getDomNode());
    }

    public void sign(PrivateKey key, X509Certificate[] cert) throws DSigException {
        Document doc = this.signInt(key, cert);
        try {
            this.xbdoc = XACMLPolicyQueryDocument.Factory.parse(doc);
            this.xmlReq = this.xbdoc.getXACMLPolicyQuery();
        }
        catch (XmlException e) {
            throw new DSigException("Parsing signed document failed", (Throwable)e);
        }
    }
}

