/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.uas.pdp.argus;

import de.fzj.unicore.wsrflite.ThreadingServices;
import eu.unicore.uas.pdp.argus.ArgusHerasafPolicyStore;
import eu.unicore.uas.pdp.argus.ArgusPAPClient;
import eu.unicore.uas.pdp.argus.PolicyRequestCreator;
import eu.unicore.util.Log;
import eu.unicore.util.configuration.ConfigurationException;
import eu.unicore.util.configuration.FilePropertiesHelper;
import eu.unicore.util.configuration.PropertyMD;
import eu.unicore.util.httpclient.IClientConfiguration;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.XmlOptions;
import xmlbeans.oasis.xacml.x2.x0.policy.PolicySetDocument;
import xmlbeans.oasis.xacml.x2.x0.policy.PolicySetType;
import xmlbeans.oasis.xacml.x2.x0.saml.assertion.XACMLPolicyQueryDocument;
import xmlbeans.oasis.xacml.x2.x0.saml.assertion.XACMLPolicyStatementType;
import xmlbeans.org.oasis.saml2.assertion.AssertionType;
import xmlbeans.org.oasis.saml2.assertion.StatementAbstractType;
import xmlbeans.org.oasis.saml2.protocol.ResponseDocument;
import xmlbeans.org.oasis.saml2.protocol.ResponseType;

public class ArgusPAPChecker {
    private static final Logger log = Log.getLogger((String)"unicore.security", ArgusPAPChecker.class);
    public static final String PREFIX = "argus.pap.";
    public static final String ADDR_KEY = "serverAddress";
    public static final String TIMEOUT_KEY = "queryTimeout";
    public static final String INTERVAL_KEY = "queryInterval";
    public static final String DENY_TIMEOUT_KEY = "denyTimeout";
    public static final String POLICY_FILENAME_KEY = "policysetFilename";
    private URL argusAddress;
    private int queryTimeout;
    private int queryInterval;
    private int denyTimeout;
    private ArgusPAPClient client;
    private XACMLPolicyQueryDocument req;
    private Object notification;
    private String argusFile;
    private long lastUpdate;
    private boolean denyAll;
    private ThreadingServices threadingSrv;
    public static Map<String, PropertyMD> META = new HashMap<String, PropertyMD>();

    public ArgusPAPChecker(String configurationFile, Object notificationObject, String baseUrl, IClientConfiguration sec, ThreadingServices threadingSrv) throws IOException {
        this.threadingSrv = threadingSrv;
        this.loadConfiguration(configurationFile);
        this.client = new ArgusPAPClient(this.argusAddress, this.queryTimeout, sec);
        this.req = PolicyRequestCreator.createSAMLPolicyQuery(baseUrl);
        this.notification = notificationObject;
    }

    private void loadConfiguration(String configurationFile) throws ConfigurationException, IOException {
        FilePropertiesHelper cfg = new FilePropertiesHelper(PREFIX, configurationFile, META, log);
        String addr = cfg.getValue(ADDR_KEY);
        try {
            this.argusAddress = new URL(addr);
        }
        catch (MalformedURLException e) {
            throw new ConfigurationException("Argus PAP URL ('" + addr + "') is invalid: " + e);
        }
        this.queryTimeout = cfg.getIntValue(TIMEOUT_KEY);
        this.queryInterval = cfg.getIntValue(INTERVAL_KEY);
        this.denyTimeout = cfg.getIntValue(DENY_TIMEOUT_KEY);
        String policyFilename = cfg.getValue(POLICY_FILENAME_KEY);
        String policiesDir = cfg.getRawProperty("localpdp.directory");
        if (policiesDir == null) {
            policiesDir = ((PropertyMD)ArgusHerasafPolicyStore.META.get("directory")).getDefault();
        }
        this.argusFile = policiesDir + File.separator + policyFilename;
        if (log.isDebugEnabled()) {
            log.debug((Object)("ArgusPAPChecker loaded configuration from " + configurationFile));
            log.debug((Object)("ArgusPAPChecker query interval time is set to " + this.queryInterval));
        }
    }

    private PolicySetDocument processResponse(ResponseDocument respDoc) throws Exception {
        PolicySetDocument doc = null;
        ResponseType resp = respDoc.getResponse();
        AssertionType[] respAssertions = resp.getAssertionArray();
        if (respAssertions == null || respAssertions.length == 0) {
            throw new Exception("Argus service error: got response (not a fault) without a SAML assertion");
        }
        StatementAbstractType[] statements = respAssertions[0].getStatementArray();
        if (statements == null || statements.length == 0) {
            throw new Exception("Argus PAP service error: response's SAML assertion has no XACML statement inside.");
        }
        for (StatementAbstractType statement : statements) {
            if (!(statement instanceof XACMLPolicyStatementType)) {
                throw new Exception("Argus PAP service error: response's SAML assertion has statement should be XACMLPolicyStatmentType, while is of " + statements[0].schemaType().getName());
            }
            XACMLPolicyStatementType xp = (XACMLPolicyStatementType)statement;
            PolicySetType[] array = xp.getPolicySetArray();
            if (array.length > 1) {
                log.warn((Object)"Argus PAP send more than 1 policySet, check configuration");
            }
            doc = PolicySetDocument.Factory.newInstance();
            doc.setPolicySet(array[0]);
        }
        return doc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void argusPAPQuery() {
        block18: {
            try {
                Object object;
                PolicySetDocument doc;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("XACML request for Argus PAP:\n" + this.req.xmlText(new XmlOptions().setSavePrettyPrint())));
                }
                ResponseDocument respDoc = this.client.sendRequest(this.req);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("XACML answer from Argus PAP:\n" + respDoc.xmlText(new XmlOptions().setSavePrettyPrint())));
                }
                if (!this.comparePolicySet(doc = this.processResponse(respDoc))) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Save new policySet in argus file: " + this.argusFile));
                    }
                    doc.save(new File(this.argusFile), new XmlOptions().setSavePrettyPrint());
                    object = this.notification;
                    synchronized (object) {
                        this.notification.notifyAll();
                    }
                }
                if (this.denyTimeout > 0) {
                    object = this;
                    synchronized (object) {
                        if (this.denyAll) {
                            log.info((Object)"DENY ALL mode OFF");
                            this.denyAll = false;
                        }
                    }
                }
                this.lastUpdate = System.currentTimeMillis();
            }
            catch (Exception e) {
                log.error((Object)"Argus PAP callout error, check connection or start argus pap server:", (Throwable)e);
                if (this.denyTimeout <= 0) break block18;
                ArgusPAPChecker argusPAPChecker = this;
                synchronized (argusPAPChecker) {
                    if (!this.denyAll && System.currentTimeMillis() - this.lastUpdate > (long)this.denyTimeout) {
                        log.info((Object)("DENY ALL mode ON. Argus PAP did not respond for more than " + this.denyTimeout + " ms"));
                        this.denyAll = true;
                    }
                }
            }
        }
    }

    public void start() {
        this.lastUpdate = System.currentTimeMillis();
        Runnable runner = new Runnable(){

            @Override
            public void run() {
                ArgusPAPChecker.this.argusPAPQuery();
            }
        };
        log.info((Object)"ArgusPAPChecker started");
        this.threadingSrv.getScheduledExecutorService().scheduleWithFixedDelay(runner, this.queryInterval, this.queryInterval, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDenyAllMode() {
        ArgusPAPChecker argusPAPChecker = this;
        synchronized (argusPAPChecker) {
            return this.denyAll;
        }
    }

    private boolean comparePolicySet(PolicySetDocument doc) throws Exception {
        boolean ans = false;
        File f = new File(this.argusFile);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Comparing local policy from file: " + this.argusFile + " and Argus PAP policy"));
        }
        if (!f.exists()) {
            ans = false;
        } else {
            try {
                PolicySetDocument document = PolicySetDocument.Factory.parse(f);
                ans = doc.toString().equals(document.toString());
            }
            catch (Exception e) {
                throw new Exception("Cannot parse policy xml file " + this.argusFile);
            }
        }
        if (log.isDebugEnabled()) {
            if (ans) {
                log.debug((Object)("Policy in " + this.argusFile + " is the same as Argus PAP server policy"));
            } else {
                log.debug((Object)("Policy in " + this.argusFile + " is not the same as Argus PAP server policy"));
            }
        }
        return ans;
    }

    static {
        META.put(ADDR_KEY, new PropertyMD("https://localhost:8150/pap/services/ProvisioningService"));
        META.put(TIMEOUT_KEY, new PropertyMD("5000"));
        META.put(INTERVAL_KEY, new PropertyMD("300000"));
        META.put(DENY_TIMEOUT_KEY, new PropertyMD("-1"));
        META.put(POLICY_FILENAME_KEY, new PropertyMD("argus_pap.xml").setPath());
    }
}

