/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xacml.ctx;

import com.sun.xacml.Indenter;
import com.sun.xacml.ParsingException;
import com.sun.xacml.ctx.InputParser;
import com.sun.xacml.ctx.Result;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ResponseCtx {
    private Set results = null;

    public ResponseCtx(Result result) {
        this.results = new HashSet();
        this.results.add(result);
    }

    public ResponseCtx(Set set) {
        this.results = Collections.unmodifiableSet(new HashSet(set));
    }

    public static ResponseCtx getInstance(Node node) throws ParsingException {
        HashSet<Result> hashSet = new HashSet<Result>();
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (!node2.getNodeName().equals("Result")) continue;
            hashSet.add(Result.getInstance(node2));
        }
        if (hashSet.size() == 0) {
            throw new ParsingException("must have at least one Result");
        }
        return new ResponseCtx(hashSet);
    }

    public static ResponseCtx getInstance(InputStream inputStream) throws ParsingException {
        return ResponseCtx.getInstance(InputParser.parseInput(inputStream, "Response"));
    }

    public Set getResults() {
        return this.results;
    }

    public void encode(OutputStream outputStream) {
        this.encode(outputStream, new Indenter(0));
    }

    public void encode(OutputStream outputStream, Indenter indenter) {
        PrintStream printStream = new PrintStream(outputStream);
        String string = indenter.makeString();
        printStream.println(string + "<Response>");
        Iterator iterator = this.results.iterator();
        indenter.in();
        while (iterator.hasNext()) {
            Result result = (Result)iterator.next();
            result.encode(printStream, indenter);
        }
        indenter.out();
        printStream.println(string + "</Response>");
    }
}

