/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xacml.cond;

import com.sun.xacml.EvaluationCtx;
import com.sun.xacml.ParsingException;
import com.sun.xacml.attr.AttributeValue;
import com.sun.xacml.attr.BagAttribute;
import com.sun.xacml.cond.Evaluatable;
import com.sun.xacml.cond.EvaluationResult;
import com.sun.xacml.cond.Function;
import com.sun.xacml.cond.FunctionFactory;
import com.sun.xacml.cond.FunctionTypeException;
import com.sun.xacml.ctx.Status;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class MapFunction
implements Function {
    public static final String NAME_MAP = "urn:oasis:names:tc:xacml:1.0:function:map";
    private URI returnType;
    private static URI identifier;
    private static RuntimeException earlyException;

    public MapFunction(URI uRI) {
        this.returnType = uRI;
    }

    public static Set getSupportedIdentifiers() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(NAME_MAP);
        return hashSet;
    }

    public static MapFunction getInstance(Node node) throws ParsingException {
        URI uRI = null;
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (!node2.getNodeName().equals("Function")) continue;
            String string = node2.getAttributes().getNamedItem("FunctionId").getNodeValue();
            FunctionFactory functionFactory = FunctionFactory.getGeneralInstance();
            try {
                Function function = functionFactory.createFunction(string);
                uRI = function.getReturnType();
                break;
            }
            catch (FunctionTypeException functionTypeException) {
                try {
                    Function function = functionFactory.createAbstractFunction(string, node);
                    uRI = function.getReturnType();
                    break;
                }
                catch (Exception exception) {
                    throw new ParsingException("invalid abstract map", exception);
                }
            }
            catch (Exception exception) {
                throw new ParsingException("couldn't parse map body", exception);
            }
        }
        if (uRI == null) {
            throw new ParsingException("couldn't find the return type");
        }
        return new MapFunction(uRI);
    }

    public URI getIdentifier() {
        if (earlyException != null) {
            throw earlyException;
        }
        return identifier;
    }

    public URI getReturnType() {
        return this.returnType;
    }

    public boolean returnsBag() {
        return true;
    }

    private static EvaluationResult makeProcessingError(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("urn:oasis:names:tc:xacml:1.0:status:processing-error");
        return new EvaluationResult(new Status(arrayList, string));
    }

    public EvaluationResult evaluate(List list, EvaluationCtx evaluationCtx) {
        Iterator iterator = list.iterator();
        Function function = (Function)iterator.next();
        BagAttribute bagAttribute = (BagAttribute)iterator.next();
        Iterator iterator2 = bagAttribute.iterator();
        ArrayList<AttributeValue> arrayList = new ArrayList<AttributeValue>();
        while (iterator2.hasNext()) {
            ArrayList arrayList2 = new ArrayList();
            arrayList2.add(iterator2.next());
            EvaluationResult evaluationResult = function.evaluate(arrayList2, evaluationCtx);
            if (evaluationResult.indeterminate()) {
                return evaluationResult;
            }
            arrayList.add(evaluationResult.getAttributeValue());
        }
        return new EvaluationResult(new BagAttribute(this.returnType, arrayList));
    }

    public void checkInputs(List list) throws IllegalArgumentException {
        Object[] objectArray = list.toArray();
        if (objectArray.length != 2) {
            throw new IllegalArgumentException("map requires two inputs");
        }
        if (!(objectArray[0] instanceof Function)) {
            throw new IllegalArgumentException("first argument to map must be a Function");
        }
        Evaluatable evaluatable = (Evaluatable)objectArray[1];
        if (!evaluatable.evaluatesToBag()) {
            throw new IllegalArgumentException("second argument to map must be a bag");
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(objectArray[1]);
        ((Function)objectArray[0]).checkInputsNoBag(arrayList);
    }

    public void checkInputsNoBag(List list) throws IllegalArgumentException {
        throw new IllegalArgumentException("map requires a bag");
    }

    static {
        try {
            identifier = new URI(NAME_MAP);
        }
        catch (Exception exception) {
            earlyException = new IllegalArgumentException();
            earlyException.initCause(exception);
        }
    }
}

