/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xacml.cond;

import com.sun.xacml.EvaluationCtx;
import com.sun.xacml.Indenter;
import com.sun.xacml.ParsingException;
import com.sun.xacml.UnknownIdentifierException;
import com.sun.xacml.attr.AttributeDesignator;
import com.sun.xacml.attr.AttributeFactory;
import com.sun.xacml.attr.AttributeSelector;
import com.sun.xacml.cond.Evaluatable;
import com.sun.xacml.cond.EvaluationResult;
import com.sun.xacml.cond.Function;
import com.sun.xacml.cond.FunctionFactory;
import com.sun.xacml.cond.FunctionTypeException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Apply
implements Evaluatable {
    private Function function;
    private List evals;
    private Function bagFunction;
    private boolean isCondition;

    public Apply(Function function, List list, boolean bl) throws IllegalArgumentException {
        this(function, list, null, bl);
    }

    public Apply(Function function, List arrayList, Function function2, boolean bl) throws IllegalArgumentException {
        ArrayList<Function> arrayList2 = arrayList;
        if (function2 != null) {
            arrayList2 = new ArrayList<Function>();
            arrayList2.add(function2);
            arrayList2.addAll(arrayList);
        }
        function.checkInputs(arrayList2);
        this.function = function;
        this.evals = Collections.unmodifiableList(new ArrayList(arrayList));
        this.bagFunction = function2;
        this.isCondition = bl;
    }

    public static Apply getConditionInstance(Node node, String string) throws ParsingException {
        return Apply.getInstance(node, FunctionFactory.getConditionInstance(), true, string);
    }

    public static Apply getInstance(Node node, String string) throws ParsingException {
        return Apply.getInstance(node, FunctionFactory.getGeneralInstance(), false, string);
    }

    private static Apply getInstance(Node node, FunctionFactory functionFactory, boolean bl, String string) throws ParsingException {
        Function function = Apply.getFunction(node, string, functionFactory);
        Function function2 = null;
        ArrayList<Evaluatable> arrayList = new ArrayList<Evaluatable>();
        AttributeFactory attributeFactory = AttributeFactory.getInstance();
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            String string2 = node2.getNodeName();
            if (string2.equals("Apply")) {
                arrayList.add(Apply.getInstance(node2, string));
                continue;
            }
            if (string2.equals("AttributeValue")) {
                try {
                    arrayList.add(attributeFactory.createValue(node2));
                    continue;
                }
                catch (UnknownIdentifierException unknownIdentifierException) {
                    throw new ParsingException("Unknown DataType", unknownIdentifierException);
                }
            }
            if (string2.equals("SubjectAttributeDesignator")) {
                arrayList.add(AttributeDesignator.getInstance(node2, 0));
                continue;
            }
            if (string2.equals("ResourceAttributeDesignator")) {
                arrayList.add(AttributeDesignator.getInstance(node2, 1));
                continue;
            }
            if (string2.equals("ActionAttributeDesignator")) {
                arrayList.add(AttributeDesignator.getInstance(node2, 2));
                continue;
            }
            if (string2.equals("EnvironmentAttributeDesignator")) {
                arrayList.add(AttributeDesignator.getInstance(node2, 3));
                continue;
            }
            if (string2.equals("AttributeSelector")) {
                arrayList.add(AttributeSelector.getInstance(node2, string));
                continue;
            }
            if (!string2.equals("Function")) continue;
            if (function2 != null) {
                throw new ParsingException("Too many FunctionTypes");
            }
            function2 = Apply.getFunction(node2, string, FunctionFactory.getGeneralInstance());
        }
        return new Apply(function, arrayList, function2, bl);
    }

    private static Function getFunction(Node node, String string, FunctionFactory functionFactory) throws ParsingException {
        Node node2 = node.getAttributes().getNamedItem("FunctionId");
        String string2 = node2.getNodeValue();
        try {
            return functionFactory.createFunction(string2);
        }
        catch (UnknownIdentifierException unknownIdentifierException) {
            throw new ParsingException("Unknown FunctionId in Apply", unknownIdentifierException);
        }
        catch (FunctionTypeException functionTypeException) {
            try {
                FunctionFactory functionFactory2 = FunctionFactory.getGeneralInstance();
                return functionFactory2.createAbstractFunction(string2, node, string);
            }
            catch (Exception exception) {
                throw new ParsingException("failed to create abstract function " + string2, exception);
            }
        }
    }

    public Function getFunction() {
        return this.function;
    }

    public List getChildren() {
        return this.evals;
    }

    public Function getHigherOrderFunction() {
        return this.bagFunction;
    }

    public boolean isCondition() {
        return this.isCondition;
    }

    public EvaluationResult evaluate(EvaluationCtx evaluationCtx) {
        ArrayList<Object> arrayList = this.evals;
        if (this.bagFunction != null) {
            arrayList = new ArrayList<Object>();
            arrayList.add(this.bagFunction);
            Iterator iterator = this.evals.iterator();
            while (iterator.hasNext()) {
                Evaluatable evaluatable = (Evaluatable)iterator.next();
                EvaluationResult evaluationResult = evaluatable.evaluate(evaluationCtx);
                if (evaluationResult.indeterminate()) {
                    return evaluationResult;
                }
                arrayList.add(evaluationResult.getAttributeValue());
            }
        }
        return this.function.evaluate(arrayList, evaluationCtx);
    }

    public URI getType() {
        return this.function.getReturnType();
    }

    public boolean evaluatesToBag() {
        return this.function.returnsBag();
    }

    public void encode(OutputStream outputStream) {
        this.encode(outputStream, new Indenter(0));
    }

    public void encode(OutputStream outputStream, Indenter indenter) {
        PrintStream printStream = new PrintStream(outputStream);
        String string = indenter.makeString();
        if (this.isCondition) {
            printStream.println(string + "<Condition FunctionId=\"" + this.function.getIdentifier() + "\">");
        } else {
            printStream.println(string + "<Apply FunctionId=\"" + this.function.getIdentifier() + "\">");
        }
        indenter.in();
        if (this.bagFunction != null) {
            printStream.println("<Function FunctionId=\"" + this.bagFunction.getIdentifier() + "\"/>");
        }
        Iterator iterator = this.evals.iterator();
        while (iterator.hasNext()) {
            Evaluatable evaluatable = (Evaluatable)iterator.next();
            evaluatable.encode(outputStream, indenter);
        }
        indenter.out();
        if (this.isCondition) {
            printStream.println(string + "</Condition>");
        } else {
            printStream.println(string + "</Apply>");
        }
    }
}

