/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xacml.attr;

import com.sun.xacml.attr.AttributeValue;
import java.net.URI;
import java.net.URISyntaxException;
import org.w3c.dom.Node;

public class AnyURIAttribute
extends AttributeValue {
    public static final String identifier = "http://www.w3.org/2001/XMLSchema#anyURI";
    private static URI identifierURI;
    private static RuntimeException earlyException;
    private URI value;

    public AnyURIAttribute(URI uRI) {
        super(identifierURI);
        if (earlyException != null) {
            throw earlyException;
        }
        this.value = uRI;
    }

    public static AnyURIAttribute getInstance(Node node) throws URISyntaxException {
        return AnyURIAttribute.getInstance(node.getFirstChild().getNodeValue());
    }

    public static AnyURIAttribute getInstance(String string) throws URISyntaxException {
        return new AnyURIAttribute(new URI(string));
    }

    public URI getValue() {
        return this.value;
    }

    public boolean equals(Object object) {
        if (!(object instanceof AnyURIAttribute)) {
            return false;
        }
        AnyURIAttribute anyURIAttribute = (AnyURIAttribute)object;
        return this.value.equals(anyURIAttribute.value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public String toString() {
        return "AnyURIAttribute: \"" + this.value.toString() + "\"";
    }

    public String encode() {
        return this.value.toString();
    }

    static {
        try {
            identifierURI = new URI(identifier);
        }
        catch (Exception exception) {
            earlyException = new IllegalArgumentException();
            earlyException.initCause(exception);
        }
    }
}

