/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xacml;

import com.sun.xacml.Indenter;
import com.sun.xacml.ParsingException;
import com.sun.xacml.UnknownIdentifierException;
import com.sun.xacml.attr.AttributeFactory;
import com.sun.xacml.attr.AttributeValue;
import com.sun.xacml.ctx.Attribute;
import com.sun.xacml.ctx.Result;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Obligation {
    private URI id;
    private int fulfillOn;
    private List assignments;

    public Obligation(URI uRI, int n, List list) {
        this.id = uRI;
        this.fulfillOn = n;
        this.assignments = Collections.unmodifiableList(new ArrayList(list));
    }

    public static Obligation getInstance(Node node) throws ParsingException {
        URI uRI;
        int n = -1;
        ArrayList<Attribute> arrayList = new ArrayList<Attribute>();
        AttributeFactory attributeFactory = AttributeFactory.getInstance();
        NamedNodeMap namedNodeMap = node.getAttributes();
        try {
            uRI = new URI(namedNodeMap.getNamedItem("ObligationId").getNodeValue());
        }
        catch (Exception exception) {
            throw new ParsingException("Error parsing required attriubte ObligationId", exception);
        }
        String string = null;
        try {
            string = namedNodeMap.getNamedItem("FulfillOn").getNodeValue();
        }
        catch (Exception exception) {
            throw new ParsingException("Error parsing required attriubte FulfillOn", exception);
        }
        if (string.equals("Permit")) {
            n = 0;
        } else if (string.equals("Deny")) {
            n = 1;
        } else {
            throw new ParsingException("Invlid Effect type: " + string);
        }
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (!node2.getNodeName().equals("AttributeAssignment")) continue;
            try {
                URI uRI2 = new URI(node2.getAttributes().getNamedItem("AttributeId").getNodeValue());
                AttributeValue attributeValue = attributeFactory.createValue(node2);
                arrayList.add(new Attribute(uRI2, null, null, attributeValue));
                continue;
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new ParsingException("Error parsing URI", uRISyntaxException);
            }
            catch (UnknownIdentifierException unknownIdentifierException) {
                throw new ParsingException("Unknown AttributeId", unknownIdentifierException);
            }
            catch (Exception exception) {
                throw new ParsingException("Error parsing attribute assignments", exception);
            }
        }
        return new Obligation(uRI, n, arrayList);
    }

    public URI getId() {
        return this.id;
    }

    public int getFulfillOn() {
        return this.fulfillOn;
    }

    public List getAssignments() {
        return this.assignments;
    }

    public void encode(OutputStream outputStream) {
        this.encode(outputStream, new Indenter(0));
    }

    public void encode(OutputStream outputStream, Indenter indenter) {
        PrintStream printStream = new PrintStream(outputStream);
        String string = indenter.makeString();
        printStream.println(string + "<Obligation ObligationId=\"" + this.id.toString() + "\" FulfillOn=\"" + Result.DECISIONS[this.fulfillOn] + "\">");
        indenter.in();
        Iterator iterator = this.assignments.iterator();
        while (iterator.hasNext()) {
            Attribute attribute = (Attribute)iterator.next();
            printStream.println(indenter.makeString() + "<AttributeAssignment AttributeId=\"" + attribute.getId().toString() + "\" DataType=\"" + attribute.getType().toString() + "\">" + attribute.getValue().encode() + "</AttributeAssignment>");
        }
        indenter.out();
        printStream.println(string + "</Obligation>");
    }
}

