/*
 * Decompiled with CFR 0.152.
 */
package org.h2.index;

import java.util.ArrayList;
import org.h2.command.dml.Query;
import org.h2.command.dml.SelectUnion;
import org.h2.engine.Session;
import org.h2.expression.Parameter;
import org.h2.index.BaseIndex;
import org.h2.index.Cursor;
import org.h2.index.IndexType;
import org.h2.index.ViewCursor;
import org.h2.message.DbException;
import org.h2.result.LocalResult;
import org.h2.result.ResultInterface;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.table.Column;
import org.h2.table.TableView;
import org.h2.util.IntArray;
import org.h2.util.SmallLRUCache;
import org.h2.util.Utils;
import org.h2.value.Value;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewIndex
extends BaseIndex {
    private final TableView view;
    private final String querySQL;
    private final ArrayList<Parameter> originalParameters;
    private final SmallLRUCache<IntArray, CostElement> costCache = SmallLRUCache.newInstance(64);
    private boolean recursive;
    private int[] indexMasks;
    private String planSQL;
    private Query query;
    private Session createSession;

    public ViewIndex(TableView tableView, String string, ArrayList<Parameter> arrayList, boolean bl) {
        this.initBaseIndex(tableView, 0, null, null, IndexType.createNonUnique(false));
        this.view = tableView;
        this.querySQL = string;
        this.originalParameters = arrayList;
        this.recursive = bl;
        this.columns = new Column[0];
    }

    public ViewIndex(TableView tableView, ViewIndex viewIndex, Session session, int[] nArray) {
        this.initBaseIndex(tableView, 0, null, null, IndexType.createNonUnique(false));
        this.view = tableView;
        this.querySQL = viewIndex.querySQL;
        this.originalParameters = viewIndex.originalParameters;
        this.recursive = viewIndex.recursive;
        this.indexMasks = nArray;
        this.createSession = session;
        this.columns = new Column[0];
        if (!this.recursive) {
            this.query = this.getQuery(session, nArray);
            this.planSQL = this.query.getPlanSQL();
        }
    }

    public Session getSession() {
        return this.createSession;
    }

    @Override
    public String getPlanSQL() {
        return this.planSQL;
    }

    @Override
    public void close(Session session) {
    }

    @Override
    public void add(Session session, Row row) {
        throw DbException.getUnsupportedException("VIEW");
    }

    @Override
    public void remove(Session session, Row row) {
        throw DbException.getUnsupportedException("VIEW");
    }

    @Override
    public double getCost(Session session, int[] nArray) {
        long l;
        if (this.recursive) {
            return 1000.0;
        }
        IntArray intArray = new IntArray(nArray == null ? Utils.EMPTY_INT_ARRAY : nArray);
        CostElement costElement = (CostElement)this.costCache.get(intArray);
        if (costElement != null && (l = System.currentTimeMillis()) < costElement.evaluatedAt + 10000L) {
            return costElement.cost;
        }
        Query query = (Query)session.prepare(this.querySQL, true);
        if (nArray != null) {
            int n;
            int n2;
            IntArray intArray2 = new IntArray();
            for (n2 = 0; n2 < nArray.length; ++n2) {
                n = nArray[n2];
                if (n == 0) continue;
                intArray2.add(n2);
            }
            n2 = intArray2.size();
            for (n = 0; n < n2; ++n) {
                Parameter parameter;
                int n3 = intArray2.get(n);
                int n4 = nArray[n3];
                int n5 = query.getParameters().size() + this.view.getParameterOffset();
                if ((n4 & 1) != 0) {
                    parameter = new Parameter(n5);
                    query.addGlobalCondition(parameter, n3, 16);
                    continue;
                }
                if ((n4 & 2) != 0) {
                    parameter = new Parameter(n5);
                    query.addGlobalCondition(parameter, n3, 1);
                }
                if ((n4 & 4) == 0) continue;
                parameter = new Parameter(n5);
                query.addGlobalCondition(parameter, n3, 3);
            }
            String string = query.getPlanSQL();
            query = (Query)session.prepare(string, true);
        }
        double d = query.getCost();
        costElement = new CostElement();
        costElement.evaluatedAt = System.currentTimeMillis();
        costElement.cost = d;
        this.costCache.put(intArray, costElement);
        return d;
    }

    @Override
    public Cursor find(Session session, SearchRow searchRow, SearchRow searchRow2) {
        int n;
        int n2;
        if (this.recursive) {
            if (this.view.getRecursiveResult() != null) {
                ResultInterface resultInterface = this.view.getRecursiveResult();
                resultInterface.reset();
                return new ViewCursor(this.table, resultInterface);
            }
            if (this.query == null) {
                this.query = (Query)this.createSession.prepare(this.querySQL, true);
                this.planSQL = this.query.getPlanSQL();
            }
            if (!(this.query instanceof SelectUnion)) {
                throw DbException.get(42001, "recursive queries without UNION ALL");
            }
            SelectUnion selectUnion = (SelectUnion)this.query;
            if (selectUnion.getUnionType() != 1) {
                throw DbException.get(42001, "recursive queries without UNION ALL");
            }
            Query query = selectUnion.getLeft();
            ResultInterface resultInterface = query.query(0);
            LocalResult localResult = selectUnion.getEmptyResult();
            while (resultInterface.next()) {
                localResult.addRow(resultInterface.currentRow());
            }
            Query query2 = selectUnion.getRight();
            resultInterface.reset();
            this.view.setRecursiveResult(resultInterface);
            while ((resultInterface = query2.query(0)).getRowCount() != 0) {
                while (resultInterface.next()) {
                    localResult.addRow(resultInterface.currentRow());
                }
                resultInterface.reset();
                this.view.setRecursiveResult(resultInterface);
            }
            return new ViewCursor(this.table, localResult);
        }
        ArrayList<Parameter> arrayList = this.query.getParameters();
        if (this.originalParameters != null) {
            n2 = this.originalParameters.size();
            for (n = 0; n < n2; ++n) {
                Parameter parameter = this.originalParameters.get(n);
                int n3 = parameter.getIndex();
                Value value = parameter.getValue(session);
                this.setParameter(arrayList, n3, value);
            }
        }
        n = searchRow != null ? searchRow.getColumnCount() : (searchRow2 != null ? searchRow2.getColumnCount() : 0);
        n2 = this.originalParameters == null ? 0 : this.originalParameters.size();
        n2 += this.view.getParameterOffset();
        for (int i = 0; i < n; ++i) {
            int n4;
            Value value;
            if (searchRow != null && (value = searchRow.getValue(i)) != null) {
                n4 = n2++;
                this.setParameter(arrayList, n4, value);
            }
            if (searchRow2 == null || this.indexMasks[i] == 1 || (value = searchRow2.getValue(i)) == null) continue;
            n4 = n2++;
            this.setParameter(arrayList, n4, value);
        }
        ResultInterface resultInterface = this.query.query(0);
        return new ViewCursor(this.table, resultInterface);
    }

    private void setParameter(ArrayList<Parameter> arrayList, int n, Value value) {
        if (n >= arrayList.size()) {
            return;
        }
        Parameter parameter = arrayList.get(n);
        parameter.setValue(value);
    }

    private Query getQuery(Session session, int[] nArray) {
        int n;
        int n2;
        Query query = (Query)session.prepare(this.querySQL, true);
        if (nArray == null) {
            return query;
        }
        int n3 = this.originalParameters == null ? 0 : this.originalParameters.size();
        n3 += this.view.getParameterOffset();
        IntArray intArray = new IntArray();
        for (n2 = 0; n2 < nArray.length; ++n2) {
            n = nArray[n2];
            if (n == 0) continue;
            intArray.add(n2);
            if ((n & 6) != 6) continue;
            intArray.add(n2);
        }
        n2 = intArray.size();
        this.columns = new Column[n2];
        n = 0;
        while (n < n2) {
            Parameter parameter;
            Column column;
            int n4 = intArray.get(n);
            this.columns[n] = column = this.table.getColumn(n4);
            int n5 = nArray[n4];
            if ((n5 & 1) == 1) {
                parameter = new Parameter(n3 + n);
                query.addGlobalCondition(parameter, n4, 16);
                ++n;
                continue;
            }
            if ((n5 & 2) == 2) {
                parameter = new Parameter(n3 + n);
                query.addGlobalCondition(parameter, n4, 1);
                ++n;
            }
            if ((n5 & 4) != 4) continue;
            parameter = new Parameter(n3 + n);
            query.addGlobalCondition(parameter, n4, 3);
            ++n;
        }
        String string = query.getPlanSQL();
        query = (Query)session.prepare(string, true);
        return query;
    }

    @Override
    public void remove(Session session) {
        throw DbException.getUnsupportedException("VIEW");
    }

    @Override
    public void truncate(Session session) {
        throw DbException.getUnsupportedException("VIEW");
    }

    @Override
    public void checkRename() {
        throw DbException.getUnsupportedException("VIEW");
    }

    @Override
    public boolean needRebuild() {
        return false;
    }

    @Override
    public boolean canGetFirstOrLast() {
        return false;
    }

    @Override
    public Cursor findFirstOrLast(Session session, boolean bl) {
        throw DbException.getUnsupportedException("VIEW");
    }

    public void setRecursive(boolean bl) {
        this.recursive = bl;
    }

    @Override
    public long getRowCount(Session session) {
        return 0L;
    }

    @Override
    public long getRowCountApproximation() {
        return 0L;
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    static class CostElement {
        long evaluatedAt;
        double cost;

        CostElement() {
        }
    }
}

